<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageSensorCaptureOutput StructType
 * @subpackage Structs
 */
class ImageSensorCaptureOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The CaptureEventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CaptureEventId;
    /**
     * The CaptureTimeStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CaptureTimeStamp;
    /**
     * The UploadDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UploadDateTime;
    /**
     * The ErrorMsg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMsg;
    /**
     * The CaptureReasons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags
     */
    public $CaptureReasons;
    /**
     * Constructor method for ImageSensorCaptureOutput
     * @uses ImageSensorCaptureOutput::setSuccess()
     * @uses ImageSensorCaptureOutput::setCaptureEventId()
     * @uses ImageSensorCaptureOutput::setCaptureTimeStamp()
     * @uses ImageSensorCaptureOutput::setUploadDateTime()
     * @uses ImageSensorCaptureOutput::setErrorMsg()
     * @uses ImageSensorCaptureOutput::setCaptureReasons()
     * @param bool $success
     * @param int $captureEventId
     * @param string $captureTimeStamp
     * @param string $uploadDateTime
     * @param string $errorMsg
     * @param \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags $captureReasons
     */
    public function __construct($success = null, $captureEventId = null, $captureTimeStamp = null, $uploadDateTime = null, $errorMsg = null, \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags $captureReasons = null)
    {
        $this
            ->setSuccess($success)
            ->setCaptureEventId($captureEventId)
            ->setCaptureTimeStamp($captureTimeStamp)
            ->setUploadDateTime($uploadDateTime)
            ->setErrorMsg($errorMsg)
            ->setCaptureReasons($captureReasons);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get CaptureEventId value
     * @return int
     */
    public function getCaptureEventId()
    {
        return $this->CaptureEventId;
    }
    /**
     * Set CaptureEventId value
     * @param int $captureEventId
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setCaptureEventId($captureEventId = null)
    {
        // validation for constraint: int
        if (!is_null($captureEventId) && !(is_int($captureEventId) || ctype_digit($captureEventId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($captureEventId, true), gettype($captureEventId)), __LINE__);
        }
        $this->CaptureEventId = $captureEventId;
        return $this;
    }
    /**
     * Get CaptureTimeStamp value
     * @return string
     */
    public function getCaptureTimeStamp()
    {
        return $this->CaptureTimeStamp;
    }
    /**
     * Set CaptureTimeStamp value
     * @param string $captureTimeStamp
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setCaptureTimeStamp($captureTimeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($captureTimeStamp) && !is_string($captureTimeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($captureTimeStamp, true), gettype($captureTimeStamp)), __LINE__);
        }
        $this->CaptureTimeStamp = $captureTimeStamp;
        return $this;
    }
    /**
     * Get UploadDateTime value
     * @return string
     */
    public function getUploadDateTime()
    {
        return $this->UploadDateTime;
    }
    /**
     * Set UploadDateTime value
     * @param string $uploadDateTime
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setUploadDateTime($uploadDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($uploadDateTime) && !is_string($uploadDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadDateTime, true), gettype($uploadDateTime)), __LINE__);
        }
        $this->UploadDateTime = $uploadDateTime;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get CaptureReasons value
     * @return \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags|null
     */
    public function getCaptureReasons()
    {
        return $this->CaptureReasons;
    }
    /**
     * Set CaptureReasons value
     * @param \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags $captureReasons
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public function setCaptureReasons(\CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags $captureReasons = null)
    {
        $this->CaptureReasons = $captureReasons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ImageSensorCaptureOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
