<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditCustomerMasterCodeInput StructType
 * @subpackage Structs
 */
class EditCustomerMasterCodeInput extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The NewMasterCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewMasterCode;
    /**
     * Constructor method for EditCustomerMasterCodeInput
     * @uses EditCustomerMasterCodeInput::setCustomerID()
     * @uses EditCustomerMasterCodeInput::setNewMasterCode()
     * @param int $customerID
     * @param string $newMasterCode
     */
    public function __construct($customerID = null, $newMasterCode = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setNewMasterCode($newMasterCode);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \CustomerManagement\StructType\EditCustomerMasterCodeInput
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get NewMasterCode value
     * @return string|null
     */
    public function getNewMasterCode()
    {
        return $this->NewMasterCode;
    }
    /**
     * Set NewMasterCode value
     * @param string $newMasterCode
     * @return \CustomerManagement\StructType\EditCustomerMasterCodeInput
     */
    public function setNewMasterCode($newMasterCode = null)
    {
        // validation for constraint: string
        if (!is_null($newMasterCode) && !is_string($newMasterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newMasterCode, true), gettype($newMasterCode)), __LINE__);
        }
        $this->NewMasterCode = $newMasterCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\EditCustomerMasterCodeInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
