<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerListItem StructType
 * @subpackage Structs
 */
class CustomerListItem extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The IsPrimaryLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimaryLoginName;
    /**
     * Constructor method for CustomerListItem
     * @uses CustomerListItem::setCustomerId()
     * @uses CustomerListItem::setIsPrimaryLoginName()
     * @param int $customerId
     * @param bool $isPrimaryLoginName
     */
    public function __construct($customerId = null, $isPrimaryLoginName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setIsPrimaryLoginName($isPrimaryLoginName);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerListItem
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get IsPrimaryLoginName value
     * @return bool
     */
    public function getIsPrimaryLoginName()
    {
        return $this->IsPrimaryLoginName;
    }
    /**
     * Set IsPrimaryLoginName value
     * @param bool $isPrimaryLoginName
     * @return \CustomerManagement\StructType\CustomerListItem
     */
    public function setIsPrimaryLoginName($isPrimaryLoginName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimaryLoginName) && !is_bool($isPrimaryLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimaryLoginName, true), gettype($isPrimaryLoginName)), __LINE__);
        }
        $this->IsPrimaryLoginName = $isPrimaryLoginName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
