<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastActivityOutput StructType
 * @subpackage Structs
 */
class LastActivityOutput extends AbstractStructBase
{
    /**
     * The SignalReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SignalReceived;
    /**
     * The EquipmentListReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EquipmentListReceived;
    /**
     * The CentralStationEventReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CentralStationEventReceived;
    /**
     * The CellSignalStrengthReading
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CellSignalStrengthReading;
    /**
     * The FirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * Constructor method for LastActivityOutput
     * @uses LastActivityOutput::setSignalReceived()
     * @uses LastActivityOutput::setEquipmentListReceived()
     * @uses LastActivityOutput::setCentralStationEventReceived()
     * @uses LastActivityOutput::setCellSignalStrengthReading()
     * @uses LastActivityOutput::setFirmwareVersion()
     * @param string $signalReceived
     * @param string $equipmentListReceived
     * @param string $centralStationEventReceived
     * @param string $cellSignalStrengthReading
     * @param string $firmwareVersion
     */
    public function __construct($signalReceived = null, $equipmentListReceived = null, $centralStationEventReceived = null, $cellSignalStrengthReading = null, $firmwareVersion = null)
    {
        $this
            ->setSignalReceived($signalReceived)
            ->setEquipmentListReceived($equipmentListReceived)
            ->setCentralStationEventReceived($centralStationEventReceived)
            ->setCellSignalStrengthReading($cellSignalStrengthReading)
            ->setFirmwareVersion($firmwareVersion);
    }
    /**
     * Get SignalReceived value
     * @return string
     */
    public function getSignalReceived()
    {
        return $this->SignalReceived;
    }
    /**
     * Set SignalReceived value
     * @param string $signalReceived
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public function setSignalReceived($signalReceived = null)
    {
        // validation for constraint: string
        if (!is_null($signalReceived) && !is_string($signalReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signalReceived, true), gettype($signalReceived)), __LINE__);
        }
        $this->SignalReceived = $signalReceived;
        return $this;
    }
    /**
     * Get EquipmentListReceived value
     * @return string
     */
    public function getEquipmentListReceived()
    {
        return $this->EquipmentListReceived;
    }
    /**
     * Set EquipmentListReceived value
     * @param string $equipmentListReceived
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public function setEquipmentListReceived($equipmentListReceived = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentListReceived) && !is_string($equipmentListReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentListReceived, true), gettype($equipmentListReceived)), __LINE__);
        }
        $this->EquipmentListReceived = $equipmentListReceived;
        return $this;
    }
    /**
     * Get CentralStationEventReceived value
     * @return string
     */
    public function getCentralStationEventReceived()
    {
        return $this->CentralStationEventReceived;
    }
    /**
     * Set CentralStationEventReceived value
     * @param string $centralStationEventReceived
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public function setCentralStationEventReceived($centralStationEventReceived = null)
    {
        // validation for constraint: string
        if (!is_null($centralStationEventReceived) && !is_string($centralStationEventReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralStationEventReceived, true), gettype($centralStationEventReceived)), __LINE__);
        }
        $this->CentralStationEventReceived = $centralStationEventReceived;
        return $this;
    }
    /**
     * Get CellSignalStrengthReading value
     * @return string|null
     */
    public function getCellSignalStrengthReading()
    {
        return $this->CellSignalStrengthReading;
    }
    /**
     * Set CellSignalStrengthReading value
     * @param string $cellSignalStrengthReading
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public function setCellSignalStrengthReading($cellSignalStrengthReading = null)
    {
        // validation for constraint: string
        if (!is_null($cellSignalStrengthReading) && !is_string($cellSignalStrengthReading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellSignalStrengthReading, true), gettype($cellSignalStrengthReading)), __LINE__);
        }
        $this->CellSignalStrengthReading = $cellSignalStrengthReading;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\LastActivityOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
