<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitmentInfo StructType
 * @subpackage Structs
 */
class CommitmentInfo extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ExpectedInstallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpectedInstallDate;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * Constructor method for CommitmentInfo
     * @uses CommitmentInfo::setCustomerId()
     * @uses CommitmentInfo::setExpectedInstallDate()
     * @uses CommitmentInfo::setExpirationDate()
     * @param int $customerId
     * @param string $expectedInstallDate
     * @param string $expirationDate
     */
    public function __construct($customerId = null, $expectedInstallDate = null, $expirationDate = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setExpectedInstallDate($expectedInstallDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CommitmentInfo
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ExpectedInstallDate value
     * @return string
     */
    public function getExpectedInstallDate()
    {
        return $this->ExpectedInstallDate;
    }
    /**
     * Set ExpectedInstallDate value
     * @param string $expectedInstallDate
     * @return \CustomerManagement\StructType\CommitmentInfo
     */
    public function setExpectedInstallDate($expectedInstallDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedInstallDate) && !is_string($expectedInstallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedInstallDate, true), gettype($expectedInstallDate)), __LINE__);
        }
        $this->ExpectedInstallDate = $expectedInstallDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \CustomerManagement\StructType\CommitmentInfo
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CommitmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
