<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeServicePlan StructType
 * @subpackage Structs
 */
class ChangeServicePlan extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newPackageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $newPackageId;
    /**
     * The addOnFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $addOnFeatures;
    /**
     * Constructor method for ChangeServicePlan
     * @uses ChangeServicePlan::setCustomerId()
     * @uses ChangeServicePlan::setNewPackageId()
     * @uses ChangeServicePlan::setAddOnFeatures()
     * @param int $customerId
     * @param int $newPackageId
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     */
    public function __construct($customerId = null, $newPackageId = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPackageId($newPackageId)
            ->setAddOnFeatures($addOnFeatures);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ChangeServicePlan
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newPackageId value
     * @return int
     */
    public function getNewPackageId()
    {
        return $this->newPackageId;
    }
    /**
     * Set newPackageId value
     * @param int $newPackageId
     * @return \CustomerManagement\StructType\ChangeServicePlan
     */
    public function setNewPackageId($newPackageId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageId) && !(is_int($newPackageId) || ctype_digit($newPackageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newPackageId, true), gettype($newPackageId)), __LINE__);
        }
        $this->newPackageId = $newPackageId;
        return $this;
    }
    /**
     * Get addOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->addOnFeatures;
    }
    /**
     * Set addOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\ChangeServicePlan
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->addOnFeatures = $addOnFeatures;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ChangeServicePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
