<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerPermissions ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerPermissions extends AbstractStructArrayBase
{
    /**
     * The CustomerPermissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CustomerPermissions[]
     */
    public $CustomerPermissions;
    /**
     * Constructor method for ArrayOfCustomerPermissions
     * @uses ArrayOfCustomerPermissions::setCustomerPermissions()
     * @param \CustomerManagement\StructType\CustomerPermissions[] $customerPermissions
     */
    public function __construct(array $customerPermissions = array())
    {
        $this
            ->setCustomerPermissions($customerPermissions);
    }
    /**
     * Get CustomerPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CustomerPermissions[]|null
     */
    public function getCustomerPermissions()
    {
        return isset($this->CustomerPermissions) ? $this->CustomerPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerPermissionsForArrayConstraintsFromSetCustomerPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerPermissionsCustomerPermissionsItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerPermissionsCustomerPermissionsItem instanceof \CustomerManagement\StructType\CustomerPermissions) {
                $invalidValues[] = is_object($arrayOfCustomerPermissionsCustomerPermissionsItem) ? get_class($arrayOfCustomerPermissionsCustomerPermissionsItem) : sprintf('%s(%s)', gettype($arrayOfCustomerPermissionsCustomerPermissionsItem), var_export($arrayOfCustomerPermissionsCustomerPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerPermissions property can only contain items of type \CustomerManagement\StructType\CustomerPermissions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerPermissions[] $customerPermissions
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPermissions
     */
    public function setCustomerPermissions(array $customerPermissions = array())
    {
        // validation for constraint: array
        if ('' !== ($customerPermissionsArrayErrorMessage = self::validateCustomerPermissionsForArrayConstraintsFromSetCustomerPermissions($customerPermissions))) {
            throw new \InvalidArgumentException($customerPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($customerPermissions) || (is_array($customerPermissions) && empty($customerPermissions))) {
            unset($this->CustomerPermissions);
        } else {
            $this->CustomerPermissions = $customerPermissions;
        }
        return $this;
    }
    /**
     * Add item to CustomerPermissions value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerPermissions $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPermissions
     */
    public function addToCustomerPermissions(\CustomerManagement\StructType\CustomerPermissions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CustomerPermissions) {
            throw new \InvalidArgumentException(sprintf('The CustomerPermissions property can only contain items of type \CustomerManagement\StructType\CustomerPermissions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerPermissions[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CustomerPermissions|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CustomerPermissions|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CustomerPermissions|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CustomerPermissions|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CustomerPermissions|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerPermissions
     */
    public function getAttributeName()
    {
        return 'CustomerPermissions';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
