<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SwapModemInput StructType
 * @subpackage Structs
 */
class SwapModemInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RestoreBackedUpSettingsAfterSwap
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RestoreBackedUpSettingsAfterSwap;
    /**
     * The NewSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewSerialNumber;
    /**
     * The SwapReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SwapReason;
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialRequest;
    /**
     * Constructor method for SwapModemInput
     * @uses SwapModemInput::setCustomerId()
     * @uses SwapModemInput::setRestoreBackedUpSettingsAfterSwap()
     * @uses SwapModemInput::setNewSerialNumber()
     * @uses SwapModemInput::setSwapReason()
     * @uses SwapModemInput::setSpecialRequest()
     * @param int $customerId
     * @param bool $restoreBackedUpSettingsAfterSwap
     * @param string $newSerialNumber
     * @param string $swapReason
     * @param string $specialRequest
     */
    public function __construct($customerId = null, $restoreBackedUpSettingsAfterSwap = null, $newSerialNumber = null, $swapReason = null, $specialRequest = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRestoreBackedUpSettingsAfterSwap($restoreBackedUpSettingsAfterSwap)
            ->setNewSerialNumber($newSerialNumber)
            ->setSwapReason($swapReason)
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RestoreBackedUpSettingsAfterSwap value
     * @return bool
     */
    public function getRestoreBackedUpSettingsAfterSwap()
    {
        return $this->RestoreBackedUpSettingsAfterSwap;
    }
    /**
     * Set RestoreBackedUpSettingsAfterSwap value
     * @param bool $restoreBackedUpSettingsAfterSwap
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setRestoreBackedUpSettingsAfterSwap($restoreBackedUpSettingsAfterSwap = null)
    {
        // validation for constraint: boolean
        if (!is_null($restoreBackedUpSettingsAfterSwap) && !is_bool($restoreBackedUpSettingsAfterSwap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restoreBackedUpSettingsAfterSwap, true), gettype($restoreBackedUpSettingsAfterSwap)), __LINE__);
        }
        $this->RestoreBackedUpSettingsAfterSwap = $restoreBackedUpSettingsAfterSwap;
        return $this;
    }
    /**
     * Get NewSerialNumber value
     * @return string|null
     */
    public function getNewSerialNumber()
    {
        return $this->NewSerialNumber;
    }
    /**
     * Set NewSerialNumber value
     * @param string $newSerialNumber
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setNewSerialNumber($newSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($newSerialNumber) && !is_string($newSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSerialNumber, true), gettype($newSerialNumber)), __LINE__);
        }
        $this->NewSerialNumber = $newSerialNumber;
        return $this;
    }
    /**
     * Get SwapReason value
     * @return string|null
     */
    public function getSwapReason()
    {
        return $this->SwapReason;
    }
    /**
     * Set SwapReason value
     * @param string $swapReason
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setSwapReason($swapReason = null)
    {
        // validation for constraint: string
        if (!is_null($swapReason) && !is_string($swapReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swapReason, true), gettype($swapReason)), __LINE__);
        }
        $this->SwapReason = $swapReason;
        return $this;
    }
    /**
     * Get SpecialRequest value
     * @return string|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @param string $specialRequest
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setSpecialRequest($specialRequest = null)
    {
        // validation for constraint: string
        if (!is_null($specialRequest) && !is_string($specialRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialRequest, true), gettype($specialRequest)), __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
