<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeaturePrice StructType
 * @subpackage Structs
 */
class FeaturePrice extends AbstractStructBase
{
    /**
     * The Feature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Feature;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * Constructor method for FeaturePrice
     * @uses FeaturePrice::setFeature()
     * @uses FeaturePrice::setPrice()
     * @uses FeaturePrice::setQuantity()
     * @param string $feature
     * @param float $price
     * @param string $quantity
     */
    public function __construct($feature = null, $price = null, $quantity = null)
    {
        $this
            ->setFeature($feature)
            ->setPrice($price)
            ->setQuantity($quantity);
    }
    /**
     * Get Feature value
     * @return string
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return \CustomerManagement\StructType\FeaturePrice
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AddOnFeatureEnum::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AddOnFeatureEnum', is_array($feature) ? implode(', ', $feature) : var_export($feature, true), implode(', ', \CustomerManagement\EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \CustomerManagement\StructType\FeaturePrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \CustomerManagement\StructType\FeaturePrice
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\FeaturePrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
