<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSystemCheckResultsOutput StructType
 * @subpackage Structs
 */
class GetSystemCheckResultsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The SystemCheckResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\SystemCheckOutput
     */
    public $SystemCheckResults;
    /**
     * Constructor method for GetSystemCheckResultsOutput
     * @uses GetSystemCheckResultsOutput::setSuccess()
     * @uses GetSystemCheckResultsOutput::setErrorMessage()
     * @uses GetSystemCheckResultsOutput::setSystemCheckResults()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\StructType\SystemCheckOutput $systemCheckResults
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\StructType\SystemCheckOutput $systemCheckResults = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setSystemCheckResults($systemCheckResults);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetSystemCheckResultsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetSystemCheckResultsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get SystemCheckResults value
     * @return \CustomerManagement\StructType\SystemCheckOutput|null
     */
    public function getSystemCheckResults()
    {
        return $this->SystemCheckResults;
    }
    /**
     * Set SystemCheckResults value
     * @param \CustomerManagement\StructType\SystemCheckOutput $systemCheckResults
     * @return \CustomerManagement\StructType\GetSystemCheckResultsOutput
     */
    public function setSystemCheckResults(\CustomerManagement\StructType\SystemCheckOutput $systemCheckResults = null)
    {
        $this->SystemCheckResults = $systemCheckResults;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetSystemCheckResultsOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
