<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelDevice StructType
 * @subpackage Structs
 */
class PanelDevice extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The InstallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallDate;
    /**
     * The MaintainDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaintainDate;
    /**
     * The StatusDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StatusDate;
    /**
     * The Partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * The MonitoredForNormalActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MonitoredForNormalActivity;
    /**
     * The DeviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceType;
    /**
     * The NonReportingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NonReportingFlag;
    /**
     * The ManufacturerSpecificInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ManufacturerSpecificInfo;
    /**
     * The IsSecondaryLoop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSecondaryLoop;
    /**
     * The IsExistingEquipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsExistingEquipment;
    /**
     * The WebSiteDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebSiteDeviceName;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public $Status;
    /**
     * The ZwaveManufacturer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZwaveManufacturer;
    /**
     * The MAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MAC;
    /**
     * The VideoDeviceModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VideoDeviceModel;
    /**
     * Constructor method for PanelDevice
     * @uses PanelDevice::setDeviceId()
     * @uses PanelDevice::setInstallDate()
     * @uses PanelDevice::setMaintainDate()
     * @uses PanelDevice::setStatusDate()
     * @uses PanelDevice::setPartition()
     * @uses PanelDevice::setMonitoredForNormalActivity()
     * @uses PanelDevice::setDeviceType()
     * @uses PanelDevice::setNonReportingFlag()
     * @uses PanelDevice::setManufacturerSpecificInfo()
     * @uses PanelDevice::setIsSecondaryLoop()
     * @uses PanelDevice::setIsExistingEquipment()
     * @uses PanelDevice::setWebSiteDeviceName()
     * @uses PanelDevice::setGroup()
     * @uses PanelDevice::setStatus()
     * @uses PanelDevice::setZwaveManufacturer()
     * @uses PanelDevice::setMAC()
     * @uses PanelDevice::setVideoDeviceModel()
     * @param int $deviceId
     * @param string $installDate
     * @param string $maintainDate
     * @param string $statusDate
     * @param int $partition
     * @param bool $monitoredForNormalActivity
     * @param string $deviceType
     * @param bool $nonReportingFlag
     * @param int $manufacturerSpecificInfo
     * @param bool $isSecondaryLoop
     * @param bool $isExistingEquipment
     * @param string $webSiteDeviceName
     * @param string $group
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum $status
     * @param string $zwaveManufacturer
     * @param string $mAC
     * @param string $videoDeviceModel
     */
    public function __construct($deviceId = null, $installDate = null, $maintainDate = null, $statusDate = null, $partition = null, $monitoredForNormalActivity = null, $deviceType = null, $nonReportingFlag = null, $manufacturerSpecificInfo = null, $isSecondaryLoop = null, $isExistingEquipment = null, $webSiteDeviceName = null, $group = null, \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum $status = null, $zwaveManufacturer = null, $mAC = null, $videoDeviceModel = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setInstallDate($installDate)
            ->setMaintainDate($maintainDate)
            ->setStatusDate($statusDate)
            ->setPartition($partition)
            ->setMonitoredForNormalActivity($monitoredForNormalActivity)
            ->setDeviceType($deviceType)
            ->setNonReportingFlag($nonReportingFlag)
            ->setManufacturerSpecificInfo($manufacturerSpecificInfo)
            ->setIsSecondaryLoop($isSecondaryLoop)
            ->setIsExistingEquipment($isExistingEquipment)
            ->setWebSiteDeviceName($webSiteDeviceName)
            ->setGroup($group)
            ->setStatus($status)
            ->setZwaveManufacturer($zwaveManufacturer)
            ->setMAC($mAC)
            ->setVideoDeviceModel($videoDeviceModel);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get InstallDate value
     * @return string
     */
    public function getInstallDate()
    {
        return $this->InstallDate;
    }
    /**
     * Set InstallDate value
     * @param string $installDate
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setInstallDate($installDate = null)
    {
        // validation for constraint: string
        if (!is_null($installDate) && !is_string($installDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installDate, true), gettype($installDate)), __LINE__);
        }
        $this->InstallDate = $installDate;
        return $this;
    }
    /**
     * Get MaintainDate value
     * @return string
     */
    public function getMaintainDate()
    {
        return $this->MaintainDate;
    }
    /**
     * Set MaintainDate value
     * @param string $maintainDate
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setMaintainDate($maintainDate = null)
    {
        // validation for constraint: string
        if (!is_null($maintainDate) && !is_string($maintainDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintainDate, true), gettype($maintainDate)), __LINE__);
        }
        $this->MaintainDate = $maintainDate;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get MonitoredForNormalActivity value
     * @return bool
     */
    public function getMonitoredForNormalActivity()
    {
        return $this->MonitoredForNormalActivity;
    }
    /**
     * Set MonitoredForNormalActivity value
     * @param bool $monitoredForNormalActivity
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setMonitoredForNormalActivity($monitoredForNormalActivity = null)
    {
        // validation for constraint: boolean
        if (!is_null($monitoredForNormalActivity) && !is_bool($monitoredForNormalActivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($monitoredForNormalActivity, true), gettype($monitoredForNormalActivity)), __LINE__);
        }
        $this->MonitoredForNormalActivity = $monitoredForNormalActivity;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceTypeEnum', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get NonReportingFlag value
     * @return bool
     */
    public function getNonReportingFlag()
    {
        return $this->NonReportingFlag;
    }
    /**
     * Set NonReportingFlag value
     * @param bool $nonReportingFlag
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setNonReportingFlag($nonReportingFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonReportingFlag) && !is_bool($nonReportingFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonReportingFlag, true), gettype($nonReportingFlag)), __LINE__);
        }
        $this->NonReportingFlag = $nonReportingFlag;
        return $this;
    }
    /**
     * Get ManufacturerSpecificInfo value
     * @return int
     */
    public function getManufacturerSpecificInfo()
    {
        return $this->ManufacturerSpecificInfo;
    }
    /**
     * Set ManufacturerSpecificInfo value
     * @param int $manufacturerSpecificInfo
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setManufacturerSpecificInfo($manufacturerSpecificInfo = null)
    {
        // validation for constraint: int
        if (!is_null($manufacturerSpecificInfo) && !(is_int($manufacturerSpecificInfo) || ctype_digit($manufacturerSpecificInfo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manufacturerSpecificInfo, true), gettype($manufacturerSpecificInfo)), __LINE__);
        }
        $this->ManufacturerSpecificInfo = $manufacturerSpecificInfo;
        return $this;
    }
    /**
     * Get IsSecondaryLoop value
     * @return bool
     */
    public function getIsSecondaryLoop()
    {
        return $this->IsSecondaryLoop;
    }
    /**
     * Set IsSecondaryLoop value
     * @param bool $isSecondaryLoop
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setIsSecondaryLoop($isSecondaryLoop = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSecondaryLoop) && !is_bool($isSecondaryLoop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSecondaryLoop, true), gettype($isSecondaryLoop)), __LINE__);
        }
        $this->IsSecondaryLoop = $isSecondaryLoop;
        return $this;
    }
    /**
     * Get IsExistingEquipment value
     * @return bool
     */
    public function getIsExistingEquipment()
    {
        return $this->IsExistingEquipment;
    }
    /**
     * Set IsExistingEquipment value
     * @param bool $isExistingEquipment
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setIsExistingEquipment($isExistingEquipment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExistingEquipment) && !is_bool($isExistingEquipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExistingEquipment, true), gettype($isExistingEquipment)), __LINE__);
        }
        $this->IsExistingEquipment = $isExistingEquipment;
        return $this;
    }
    /**
     * Get WebSiteDeviceName value
     * @return string|null
     */
    public function getWebSiteDeviceName()
    {
        return $this->WebSiteDeviceName;
    }
    /**
     * Set WebSiteDeviceName value
     * @param string $webSiteDeviceName
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setWebSiteDeviceName($webSiteDeviceName = null)
    {
        // validation for constraint: string
        if (!is_null($webSiteDeviceName) && !is_string($webSiteDeviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSiteDeviceName, true), gettype($webSiteDeviceName)), __LINE__);
        }
        $this->WebSiteDeviceName = $webSiteDeviceName;
        return $this;
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get Status value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum $status
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setStatus(\CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ZwaveManufacturer value
     * @return string|null
     */
    public function getZwaveManufacturer()
    {
        return $this->ZwaveManufacturer;
    }
    /**
     * Set ZwaveManufacturer value
     * @param string $zwaveManufacturer
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setZwaveManufacturer($zwaveManufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($zwaveManufacturer) && !is_string($zwaveManufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zwaveManufacturer, true), gettype($zwaveManufacturer)), __LINE__);
        }
        $this->ZwaveManufacturer = $zwaveManufacturer;
        return $this;
    }
    /**
     * Get MAC value
     * @return string|null
     */
    public function getMAC()
    {
        return $this->MAC;
    }
    /**
     * Set MAC value
     * @param string $mAC
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setMAC($mAC = null)
    {
        // validation for constraint: string
        if (!is_null($mAC) && !is_string($mAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mAC, true), gettype($mAC)), __LINE__);
        }
        $this->MAC = $mAC;
        return $this;
    }
    /**
     * Get VideoDeviceModel value
     * @return string|null
     */
    public function getVideoDeviceModel()
    {
        return $this->VideoDeviceModel;
    }
    /**
     * Set VideoDeviceModel value
     * @param string $videoDeviceModel
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public function setVideoDeviceModel($videoDeviceModel = null)
    {
        // validation for constraint: string
        if (!is_null($videoDeviceModel) && !is_string($videoDeviceModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($videoDeviceModel, true), gettype($videoDeviceModel)), __LINE__);
        }
        $this->VideoDeviceModel = $videoDeviceModel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\PanelDevice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
