<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerToGroup StructType
 * @subpackage Structs
 */
class AddCustomerToGroup extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The systemGroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $systemGroupId;
    /**
     * Constructor method for AddCustomerToGroup
     * @uses AddCustomerToGroup::setCustomerId()
     * @uses AddCustomerToGroup::setSystemGroupId()
     * @param int $customerId
     * @param int $systemGroupId
     */
    public function __construct($customerId = null, $systemGroupId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSystemGroupId($systemGroupId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddCustomerToGroup
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get systemGroupId value
     * @return int
     */
    public function getSystemGroupId()
    {
        return $this->systemGroupId;
    }
    /**
     * Set systemGroupId value
     * @param int $systemGroupId
     * @return \CustomerManagement\StructType\AddCustomerToGroup
     */
    public function setSystemGroupId($systemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($systemGroupId) && !(is_int($systemGroupId) || ctype_digit($systemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemGroupId, true), gettype($systemGroupId)), __LINE__);
        }
        $this->systemGroupId = $systemGroupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddCustomerToGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
