<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUserCodeInput StructType
 * @subpackage Structs
 */
class AddUserCodeInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The VoiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $VoiceAccess;
    /**
     * The PartitionFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartitionFlags;
    /**
     * The UserFirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserFirstName;
    /**
     * The UserLastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserLastName;
    /**
     * The NewUserCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewUserCode;
    /**
     * The EnabledAccessPointDeviceIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $EnabledAccessPointDeviceIds;
    /**
     * Constructor method for AddUserCodeInput
     * @uses AddUserCodeInput::setCustomerId()
     * @uses AddUserCodeInput::setVoiceAccess()
     * @uses AddUserCodeInput::setPartitionFlags()
     * @uses AddUserCodeInput::setUserFirstName()
     * @uses AddUserCodeInput::setUserLastName()
     * @uses AddUserCodeInput::setNewUserCode()
     * @uses AddUserCodeInput::setEnabledAccessPointDeviceIds()
     * @param int $customerId
     * @param bool $voiceAccess
     * @param int $partitionFlags
     * @param string $userFirstName
     * @param string $userLastName
     * @param string $newUserCode
     * @param \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds
     */
    public function __construct($customerId = null, $voiceAccess = null, $partitionFlags = null, $userFirstName = null, $userLastName = null, $newUserCode = null, \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setVoiceAccess($voiceAccess)
            ->setPartitionFlags($partitionFlags)
            ->setUserFirstName($userFirstName)
            ->setUserLastName($userLastName)
            ->setNewUserCode($newUserCode)
            ->setEnabledAccessPointDeviceIds($enabledAccessPointDeviceIds);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get VoiceAccess value
     * @return bool
     */
    public function getVoiceAccess()
    {
        return $this->VoiceAccess;
    }
    /**
     * Set VoiceAccess value
     * @param bool $voiceAccess
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setVoiceAccess($voiceAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($voiceAccess) && !is_bool($voiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($voiceAccess, true), gettype($voiceAccess)), __LINE__);
        }
        $this->VoiceAccess = $voiceAccess;
        return $this;
    }
    /**
     * Get PartitionFlags value
     * @return int
     */
    public function getPartitionFlags()
    {
        return $this->PartitionFlags;
    }
    /**
     * Set PartitionFlags value
     * @param int $partitionFlags
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setPartitionFlags($partitionFlags = null)
    {
        // validation for constraint: int
        if (!is_null($partitionFlags) && !(is_int($partitionFlags) || ctype_digit($partitionFlags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partitionFlags, true), gettype($partitionFlags)), __LINE__);
        }
        $this->PartitionFlags = $partitionFlags;
        return $this;
    }
    /**
     * Get UserFirstName value
     * @return string|null
     */
    public function getUserFirstName()
    {
        return $this->UserFirstName;
    }
    /**
     * Set UserFirstName value
     * @param string $userFirstName
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setUserFirstName($userFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($userFirstName) && !is_string($userFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userFirstName, true), gettype($userFirstName)), __LINE__);
        }
        $this->UserFirstName = $userFirstName;
        return $this;
    }
    /**
     * Get UserLastName value
     * @return string|null
     */
    public function getUserLastName()
    {
        return $this->UserLastName;
    }
    /**
     * Set UserLastName value
     * @param string $userLastName
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setUserLastName($userLastName = null)
    {
        // validation for constraint: string
        if (!is_null($userLastName) && !is_string($userLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLastName, true), gettype($userLastName)), __LINE__);
        }
        $this->UserLastName = $userLastName;
        return $this;
    }
    /**
     * Get NewUserCode value
     * @return string|null
     */
    public function getNewUserCode()
    {
        return $this->NewUserCode;
    }
    /**
     * Set NewUserCode value
     * @param string $newUserCode
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setNewUserCode($newUserCode = null)
    {
        // validation for constraint: string
        if (!is_null($newUserCode) && !is_string($newUserCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newUserCode, true), gettype($newUserCode)), __LINE__);
        }
        $this->NewUserCode = $newUserCode;
        return $this;
    }
    /**
     * Get EnabledAccessPointDeviceIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getEnabledAccessPointDeviceIds()
    {
        return $this->EnabledAccessPointDeviceIds;
    }
    /**
     * Set EnabledAccessPointDeviceIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public function setEnabledAccessPointDeviceIds(\CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds = null)
    {
        $this->EnabledAccessPointDeviceIds = $enabledAccessPointDeviceIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddUserCodeInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
