<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerLoginInfoInput StructType
 * @subpackage Structs
 */
class UpdateCustomerLoginInfoInput extends AbstractStructBase
{
    /**
     * The LoginId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The NewCulture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewCulture;
    /**
     * The NewLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewLoginName;
    /**
     * The NewLoginNameAtAuthenticationProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewLoginNameAtAuthenticationProvider;
    /**
     * The NewEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewEmailAddress;
    /**
     * Constructor method for UpdateCustomerLoginInfoInput
     * @uses UpdateCustomerLoginInfoInput::setLoginId()
     * @uses UpdateCustomerLoginInfoInput::setNewCulture()
     * @uses UpdateCustomerLoginInfoInput::setNewLoginName()
     * @uses UpdateCustomerLoginInfoInput::setNewLoginNameAtAuthenticationProvider()
     * @uses UpdateCustomerLoginInfoInput::setNewEmailAddress()
     * @param int $loginId
     * @param string $newCulture
     * @param string $newLoginName
     * @param string $newLoginNameAtAuthenticationProvider
     * @param string $newEmailAddress
     */
    public function __construct($loginId = null, $newCulture = null, $newLoginName = null, $newLoginNameAtAuthenticationProvider = null, $newEmailAddress = null)
    {
        $this
            ->setLoginId($loginId)
            ->setNewCulture($newCulture)
            ->setNewLoginName($newLoginName)
            ->setNewLoginNameAtAuthenticationProvider($newLoginNameAtAuthenticationProvider)
            ->setNewEmailAddress($newEmailAddress);
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get NewCulture value
     * @return string
     */
    public function getNewCulture()
    {
        return $this->NewCulture;
    }
    /**
     * Set NewCulture value
     * @uses \CustomerManagement\EnumType\CultureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CultureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newCulture
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public function setNewCulture($newCulture = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CultureEnum::valueIsValid($newCulture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CultureEnum', is_array($newCulture) ? implode(', ', $newCulture) : var_export($newCulture, true), implode(', ', \CustomerManagement\EnumType\CultureEnum::getValidValues())), __LINE__);
        }
        $this->NewCulture = $newCulture;
        return $this;
    }
    /**
     * Get NewLoginName value
     * @return string|null
     */
    public function getNewLoginName()
    {
        return $this->NewLoginName;
    }
    /**
     * Set NewLoginName value
     * @param string $newLoginName
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public function setNewLoginName($newLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($newLoginName) && !is_string($newLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLoginName, true), gettype($newLoginName)), __LINE__);
        }
        $this->NewLoginName = $newLoginName;
        return $this;
    }
    /**
     * Get NewLoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getNewLoginNameAtAuthenticationProvider()
    {
        return $this->NewLoginNameAtAuthenticationProvider;
    }
    /**
     * Set NewLoginNameAtAuthenticationProvider value
     * @param string $newLoginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public function setNewLoginNameAtAuthenticationProvider($newLoginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($newLoginNameAtAuthenticationProvider) && !is_string($newLoginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLoginNameAtAuthenticationProvider, true), gettype($newLoginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->NewLoginNameAtAuthenticationProvider = $newLoginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Get NewEmailAddress value
     * @return string|null
     */
    public function getNewEmailAddress()
    {
        return $this->NewEmailAddress;
    }
    /**
     * Set NewEmailAddress value
     * @param string $newEmailAddress
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public function setNewEmailAddress($newEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newEmailAddress) && !is_string($newEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newEmailAddress, true), gettype($newEmailAddress)), __LINE__);
        }
        $this->NewEmailAddress = $newEmailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
