<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyPanelTemplate StructType
 * @subpackage Structs
 */
class ApplyPanelTemplate extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The panelTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $panelTemplateId;
    /**
     * Constructor method for ApplyPanelTemplate
     * @uses ApplyPanelTemplate::setCustomerId()
     * @uses ApplyPanelTemplate::setPanelTemplateId()
     * @param int $customerId
     * @param int $panelTemplateId
     */
    public function __construct($customerId = null, $panelTemplateId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPanelTemplateId($panelTemplateId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ApplyPanelTemplate
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get panelTemplateId value
     * @return int
     */
    public function getPanelTemplateId()
    {
        return $this->panelTemplateId;
    }
    /**
     * Set panelTemplateId value
     * @param int $panelTemplateId
     * @return \CustomerManagement\StructType\ApplyPanelTemplate
     */
    public function setPanelTemplateId($panelTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($panelTemplateId) && !(is_int($panelTemplateId) || ctype_digit($panelTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelTemplateId, true), gettype($panelTemplateId)), __LINE__);
        }
        $this->panelTemplateId = $panelTemplateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ApplyPanelTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
