<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerEnergyProgramEligibility StructType
 * @subpackage Structs
 */
class GetCustomerEnergyProgramEligibility extends AbstractStructBase
{
    /**
     * The program
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $program;
    /**
     * Constructor method for GetCustomerEnergyProgramEligibility
     * @uses GetCustomerEnergyProgramEligibility::setProgram()
     * @param string $program
     */
    public function __construct($program = null)
    {
        $this
            ->setProgram($program);
    }
    /**
     * Get program value
     * @return string
     */
    public function getProgram()
    {
        return $this->program;
    }
    /**
     * Set program value
     * @uses \CustomerManagement\EnumType\EnergyProgramEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EnergyProgramEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $program
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibility
     */
    public function setProgram($program = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EnergyProgramEnum::valueIsValid($program)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $program, implode(', ', \CustomerManagement\EnumType\EnergyProgramEnum::getValidValues())), __LINE__);
        }
        $this->program = $program;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
