<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerNotificationEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerNotificationEnum extends AbstractStructArrayBase
{
    /**
     * The CustomerNotificationEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustomerNotificationEnum;
    /**
     * Constructor method for ArrayOfCustomerNotificationEnum
     * @uses ArrayOfCustomerNotificationEnum::setCustomerNotificationEnum()
     * @param string[] $customerNotificationEnum
     */
    public function __construct(array $customerNotificationEnum = array())
    {
        $this
            ->setCustomerNotificationEnum($customerNotificationEnum);
    }
    /**
     * Get CustomerNotificationEnum value
     * @return string[]|null
     */
    public function getCustomerNotificationEnum()
    {
        return $this->CustomerNotificationEnum;
    }
    /**
     * Set CustomerNotificationEnum value
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $customerNotificationEnum
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function setCustomerNotificationEnum(array $customerNotificationEnum = array())
    {
        $invalidValues = array();
        foreach ($customerNotificationEnum as $arrayOfCustomerNotificationEnumCustomerNotificationEnumItem) {
            if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem)) {
                $invalidValues[] = var_export($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues())), __LINE__);
        }
        $this->CustomerNotificationEnum = $customerNotificationEnum;
        return $this;
    }
    /**
     * Add item to CustomerNotificationEnum value
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function addToCustomerNotificationEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues())), __LINE__);
        }
        $this->CustomerNotificationEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerNotificationEnum
     */
    public function getAttributeName()
    {
        return 'CustomerNotificationEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
