<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCaptureReasonFlags ArrayType
 * @subpackage Arrays
 */
class ArrayOfCaptureReasonFlags extends AbstractStructArrayBase
{
    /**
     * The CaptureReasonFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CaptureReasonFlags;
    /**
     * Constructor method for ArrayOfCaptureReasonFlags
     * @uses ArrayOfCaptureReasonFlags::setCaptureReasonFlags()
     * @param string[] $captureReasonFlags
     */
    public function __construct(array $captureReasonFlags = array())
    {
        $this
            ->setCaptureReasonFlags($captureReasonFlags);
    }
    /**
     * Get CaptureReasonFlags value
     * @return string[]|null
     */
    public function getCaptureReasonFlags()
    {
        return $this->CaptureReasonFlags;
    }
    /**
     * Set CaptureReasonFlags value
     * @uses \CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid()
     * @uses \CustomerManagement\EnumType\CaptureReasonFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $captureReasonFlags
     * @return \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags
     */
    public function setCaptureReasonFlags(array $captureReasonFlags = array())
    {
        $invalidValues = array();
        foreach ($captureReasonFlags as $arrayOfCaptureReasonFlagsCaptureReasonFlagsItem) {
            if (!\CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid($arrayOfCaptureReasonFlagsCaptureReasonFlagsItem)) {
                $invalidValues[] = var_export($arrayOfCaptureReasonFlagsCaptureReasonFlagsItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\CaptureReasonFlags::getValidValues())), __LINE__);
        }
        $this->CaptureReasonFlags = $captureReasonFlags;
        return $this;
    }
    /**
     * Add item to CaptureReasonFlags value
     * @uses \CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid()
     * @uses \CustomerManagement\EnumType\CaptureReasonFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags
     */
    public function addToCaptureReasonFlags($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CaptureReasonFlags::getValidValues())), __LINE__);
        }
        $this->CaptureReasonFlags[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\CaptureReasonFlags::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CaptureReasonFlags::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CaptureReasonFlags
     */
    public function getAttributeName()
    {
        return 'CaptureReasonFlags';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCaptureReasonFlags
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
