<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNetworkEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfNetworkEnum extends AbstractStructArrayBase
{
    /**
     * The NetworkEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NetworkEnum;
    /**
     * Constructor method for ArrayOfNetworkEnum
     * @uses ArrayOfNetworkEnum::setNetworkEnum()
     * @param string[] $networkEnum
     */
    public function __construct(array $networkEnum = array())
    {
        $this
            ->setNetworkEnum($networkEnum);
    }
    /**
     * Get NetworkEnum value
     * @return string[]|null
     */
    public function getNetworkEnum()
    {
        return $this->NetworkEnum;
    }
    /**
     * Set NetworkEnum value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $networkEnum
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function setNetworkEnum(array $networkEnum = array())
    {
        $invalidValues = array();
        foreach ($networkEnum as $arrayOfNetworkEnumNetworkEnumItem) {
            if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($arrayOfNetworkEnumNetworkEnumItem)) {
                $invalidValues[] = var_export($arrayOfNetworkEnumNetworkEnumItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->NetworkEnum = $networkEnum;
        return $this;
    }
    /**
     * Add item to NetworkEnum value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function addToNetworkEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->NetworkEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NetworkEnum
     */
    public function getAttributeName()
    {
        return 'NetworkEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfNetworkEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
