<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceTypeEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeviceTypeEnum extends AbstractStructArrayBase
{
    /**
     * The DeviceTypeEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DeviceTypeEnum;
    /**
     * Constructor method for ArrayOfDeviceTypeEnum
     * @uses ArrayOfDeviceTypeEnum::setDeviceTypeEnum()
     * @param string[] $deviceTypeEnum
     */
    public function __construct(array $deviceTypeEnum = array())
    {
        $this
            ->setDeviceTypeEnum($deviceTypeEnum);
    }
    /**
     * Get DeviceTypeEnum value
     * @return string[]|null
     */
    public function getDeviceTypeEnum()
    {
        return $this->DeviceTypeEnum;
    }
    /**
     * Set DeviceTypeEnum value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceTypeEnum
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum
     */
    public function setDeviceTypeEnum(array $deviceTypeEnum = array())
    {
        $invalidValues = array();
        foreach ($deviceTypeEnum as $arrayOfDeviceTypeEnumDeviceTypeEnumItem) {
            if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($arrayOfDeviceTypeEnumDeviceTypeEnumItem)) {
                $invalidValues[] = var_export($arrayOfDeviceTypeEnumDeviceTypeEnumItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceTypeEnum = $deviceTypeEnum;
        return $this;
    }
    /**
     * Add item to DeviceTypeEnum value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum
     */
    public function addToDeviceTypeEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceTypeEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceTypeEnum
     */
    public function getAttributeName()
    {
        return 'DeviceTypeEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
