<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceStatusEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeviceStatusEnum extends AbstractStructArrayBase
{
    /**
     * The DeviceStatusEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DeviceStatusEnum;
    /**
     * Constructor method for ArrayOfDeviceStatusEnum
     * @uses ArrayOfDeviceStatusEnum::setDeviceStatusEnum()
     * @param string[] $deviceStatusEnum
     */
    public function __construct(array $deviceStatusEnum = array())
    {
        $this
            ->setDeviceStatusEnum($deviceStatusEnum);
    }
    /**
     * Get DeviceStatusEnum value
     * @return string[]|null
     */
    public function getDeviceStatusEnum()
    {
        return $this->DeviceStatusEnum;
    }
    /**
     * Set DeviceStatusEnum value
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceStatusEnum
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function setDeviceStatusEnum(array $deviceStatusEnum = array())
    {
        $invalidValues = array();
        foreach ($deviceStatusEnum as $arrayOfDeviceStatusEnumDeviceStatusEnumItem) {
            if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($arrayOfDeviceStatusEnumDeviceStatusEnumItem)) {
                $invalidValues[] = var_export($arrayOfDeviceStatusEnumDeviceStatusEnumItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues())), __LINE__);
        }
        $this->DeviceStatusEnum = $deviceStatusEnum;
        return $this;
    }
    /**
     * Add item to DeviceStatusEnum value
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function addToDeviceStatusEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues())), __LINE__);
        }
        $this->DeviceStatusEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceStatusEnum
     */
    public function getAttributeName()
    {
        return 'DeviceStatusEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
