<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCentralStationEventGroupEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfCentralStationEventGroupEnum extends AbstractStructArrayBase
{
    /**
     * The CentralStationEventGroupEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CentralStationEventGroupEnum;
    /**
     * Constructor method for ArrayOfCentralStationEventGroupEnum
     * @uses ArrayOfCentralStationEventGroupEnum::setCentralStationEventGroupEnum()
     * @param string[] $centralStationEventGroupEnum
     */
    public function __construct(array $centralStationEventGroupEnum = array())
    {
        $this
            ->setCentralStationEventGroupEnum($centralStationEventGroupEnum);
    }
    /**
     * Get CentralStationEventGroupEnum value
     * @return string[]|null
     */
    public function getCentralStationEventGroupEnum()
    {
        return $this->CentralStationEventGroupEnum;
    }
    /**
     * Set CentralStationEventGroupEnum value
     * @uses \CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationEventGroupEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $centralStationEventGroupEnum
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public function setCentralStationEventGroupEnum(array $centralStationEventGroupEnum = array())
    {
        $invalidValues = array();
        foreach ($centralStationEventGroupEnum as $arrayOfCentralStationEventGroupEnumCentralStationEventGroupEnumItem) {
            if (!\CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid($arrayOfCentralStationEventGroupEnumCentralStationEventGroupEnumItem)) {
                $invalidValues[] = var_export($arrayOfCentralStationEventGroupEnumCentralStationEventGroupEnumItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \CustomerManagement\EnumType\CentralStationEventGroupEnum::getValidValues())), __LINE__);
        }
        $this->CentralStationEventGroupEnum = $centralStationEventGroupEnum;
        return $this;
    }
    /**
     * Add item to CentralStationEventGroupEnum value
     * @uses \CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationEventGroupEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public function addToCentralStationEventGroupEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CentralStationEventGroupEnum::getValidValues())), __LINE__);
        }
        $this->CentralStationEventGroupEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public function add($item)
    {
        if (!\CustomerManagement\EnumType\CentralStationEventGroupEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \CustomerManagement\EnumType\CentralStationEventGroupEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CentralStationEventGroupEnum
     */
    public function getAttributeName()
    {
        return 'CentralStationEventGroupEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
