<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for EventTypeEnum EnumType
 * @subpackage Enumerations
 */
class EventTypeEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Alarm'
     * @return string 'Alarm'
     */
    const VALUE_ALARM = 'Alarm';
    /**
     * Constant for value 'Value'
     * @return string 'Value'
     */
    const VALUE_VALUE = 'Value';
    /**
     * Constant for value 'FireAlarm'
     * @return string 'FireAlarm'
     */
    const VALUE_FIRE_ALARM = 'FireAlarm';
    /**
     * Constant for value 'LowBattery'
     * @return string 'LowBattery'
     */
    const VALUE_LOW_BATTERY = 'LowBattery';
    /**
     * Constant for value 'PowerFailure'
     * @return string 'PowerFailure'
     */
    const VALUE_POWER_FAILURE = 'PowerFailure';
    /**
     * Constant for value 'Malfunction'
     * @return string 'Malfunction'
     */
    const VALUE_MALFUNCTION = 'Malfunction';
    /**
     * Constant for value 'Tamper'
     * @return string 'Tamper'
     */
    const VALUE_TAMPER = 'Tamper';
    /**
     * Constant for value 'Disarmed'
     * @return string 'Disarmed'
     */
    const VALUE_DISARMED = 'Disarmed';
    /**
     * Constant for value 'ArmedStay'
     * @return string 'ArmedStay'
     */
    const VALUE_ARMED_STAY = 'ArmedStay';
    /**
     * Constant for value 'ArmedAway'
     * @return string 'ArmedAway'
     */
    const VALUE_ARMED_AWAY = 'ArmedAway';
    /**
     * Constant for value 'ArmingFailed'
     * @return string 'ArmingFailed'
     */
    const VALUE_ARMING_FAILED = 'ArmingFailed';
    /**
     * Constant for value 'DisarmingFailed'
     * @return string 'DisarmingFailed'
     */
    const VALUE_DISARMING_FAILED = 'DisarmingFailed';
    /**
     * Constant for value 'Bypassed'
     * @return string 'Bypassed'
     */
    const VALUE_BYPASSED = 'Bypassed';
    /**
     * Constant for value 'Programmed'
     * @return string 'Programmed'
     */
    const VALUE_PROGRAMMED = 'Programmed';
    /**
     * Constant for value 'Opened'
     * @return string 'Opened'
     */
    const VALUE_OPENED = 'Opened';
    /**
     * Constant for value 'PowerRestored'
     * @return string 'PowerRestored'
     */
    const VALUE_POWER_RESTORED = 'PowerRestored';
    /**
     * Constant for value 'AuxiliaryPanic'
     * @return string 'AuxiliaryPanic'
     */
    const VALUE_AUXILIARY_PANIC = 'AuxiliaryPanic';
    /**
     * Constant for value 'Duress'
     * @return string 'Duress'
     */
    const VALUE_DURESS = 'Duress';
    /**
     * Constant for value 'PhoneLineFailure'
     * @return string 'PhoneLineFailure'
     */
    const VALUE_PHONE_LINE_FAILURE = 'PhoneLineFailure';
    /**
     * Constant for value 'PanelNotResponding'
     * @return string 'PanelNotResponding'
     */
    const VALUE_PANEL_NOT_RESPONDING = 'PanelNotResponding';
    /**
     * Constant for value 'TemperatureAlert'
     * @return string 'TemperatureAlert'
     */
    const VALUE_TEMPERATURE_ALERT = 'TemperatureAlert';
    /**
     * Constant for value 'PolicePanic'
     * @return string 'PolicePanic'
     */
    const VALUE_POLICE_PANIC = 'PolicePanic';
    /**
     * Constant for value 'CarbonMonoxide'
     * @return string 'CarbonMonoxide'
     */
    const VALUE_CARBON_MONOXIDE = 'CarbonMonoxide';
    /**
     * Constant for value 'FirePanic'
     * @return string 'FirePanic'
     */
    const VALUE_FIRE_PANIC = 'FirePanic';
    /**
     * Constant for value 'NoActivityAlarm'
     * @return string 'NoActivityAlarm'
     */
    const VALUE_NO_ACTIVITY_ALARM = 'NoActivityAlarm';
    /**
     * Constant for value 'FloodExtremeTempAlarm'
     * @return string 'FloodExtremeTempAlarm'
     */
    const VALUE_FLOOD_EXTREME_TEMP_ALARM = 'FloodExtremeTempAlarm';
    /**
     * Constant for value 'ExitFault'
     * @return string 'ExitFault'
     */
    const VALUE_EXIT_FAULT = 'ExitFault';
    /**
     * Constant for value 'RecentArming'
     * @return string 'RecentArming'
     */
    const VALUE_RECENT_ARMING = 'RecentArming';
    /**
     * Constant for value 'EndOfTampering'
     * @return string 'EndOfTampering'
     */
    const VALUE_END_OF_TAMPERING = 'EndOfTampering';
    /**
     * Constant for value 'PhoneLineRestored'
     * @return string 'PhoneLineRestored'
     */
    const VALUE_PHONE_LINE_RESTORED = 'PhoneLineRestored';
    /**
     * Constant for value 'EndOfMalfunction'
     * @return string 'EndOfMalfunction'
     */
    const VALUE_END_OF_MALFUNCTION = 'EndOfMalfunction';
    /**
     * Constant for value 'KeypadTamperAlarm'
     * @return string 'KeypadTamperAlarm'
     */
    const VALUE_KEYPAD_TAMPER_ALARM = 'KeypadTamperAlarm';
    /**
     * Constant for value 'TamperAlarm'
     * @return string 'TamperAlarm'
     */
    const VALUE_TAMPER_ALARM = 'TamperAlarm';
    /**
     * Constant for value 'WaterAlarm'
     * @return string 'WaterAlarm'
     */
    const VALUE_WATER_ALARM = 'WaterAlarm';
    /**
     * Constant for value 'EndOfBypass'
     * @return string 'EndOfBypass'
     */
    const VALUE_END_OF_BYPASS = 'EndOfBypass';
    /**
     * Constant for value 'BatteryOk'
     * @return string 'BatteryOk'
     */
    const VALUE_BATTERY_OK = 'BatteryOk';
    /**
     * Constant for value 'ModuleMalfunction'
     * @return string 'ModuleMalfunction'
     */
    const VALUE_MODULE_MALFUNCTION = 'ModuleMalfunction';
    /**
     * Constant for value 'RadioOff'
     * @return string 'RadioOff'
     */
    const VALUE_RADIO_OFF = 'RadioOff';
    /**
     * Constant for value 'RadioRestored'
     * @return string 'RadioRestored'
     */
    const VALUE_RADIO_RESTORED = 'RadioRestored';
    /**
     * Constant for value 'EndOfModuleMalfunction'
     * @return string 'EndOfModuleMalfunction'
     */
    const VALUE_END_OF_MODULE_MALFUNCTION = 'EndOfModuleMalfunction';
    /**
     * Constant for value 'SilentAlarmClear'
     * @return string 'SilentAlarmClear'
     */
    const VALUE_SILENT_ALARM_CLEAR = 'SilentAlarmClear';
    /**
     * Constant for value 'GeSpecialEvent'
     * @return string 'GeSpecialEvent'
     */
    const VALUE_GE_SPECIAL_EVENT = 'GeSpecialEvent';
    /**
     * Constant for value 'InactivityFault'
     * @return string 'InactivityFault'
     */
    const VALUE_INACTIVITY_FAULT = 'InactivityFault';
    /**
     * Constant for value 'InactivityRestoral'
     * @return string 'InactivityRestoral'
     */
    const VALUE_INACTIVITY_RESTORAL = 'InactivityRestoral';
    /**
     * Constant for value 'DuressAlarmClear'
     * @return string 'DuressAlarmClear'
     */
    const VALUE_DURESS_ALARM_CLEAR = 'DuressAlarmClear';
    /**
     * Constant for value 'ClearActiveAlarms'
     * @return string 'ClearActiveAlarms'
     */
    const VALUE_CLEAR_ACTIVE_ALARMS = 'ClearActiveAlarms';
    /**
     * Constant for value 'DisarmingSupervisionFault'
     * @return string 'DisarmingSupervisionFault'
     */
    const VALUE_DISARMING_SUPERVISION_FAULT = 'DisarmingSupervisionFault';
    /**
     * Constant for value 'ArmingSupervisionFault'
     * @return string 'ArmingSupervisionFault'
     */
    const VALUE_ARMING_SUPERVISION_FAULT = 'ArmingSupervisionFault';
    /**
     * Constant for value 'AutoPhoneTest'
     * @return string 'AutoPhoneTest'
     */
    const VALUE_AUTO_PHONE_TEST = 'AutoPhoneTest';
    /**
     * Constant for value 'ManualPhoneTest'
     * @return string 'ManualPhoneTest'
     */
    const VALUE_MANUAL_PHONE_TEST = 'ManualPhoneTest';
    /**
     * Constant for value 'CsForwardingFailure'
     * @return string 'CsForwardingFailure'
     */
    const VALUE_CS_FORWARDING_FAILURE = 'CsForwardingFailure';
    /**
     * Constant for value 'PanelCommunicationFailure'
     * @return string 'PanelCommunicationFailure'
     */
    const VALUE_PANEL_COMMUNICATION_FAILURE = 'PanelCommunicationFailure';
    /**
     * Constant for value 'PanelCommunicationRestore'
     * @return string 'PanelCommunicationRestore'
     */
    const VALUE_PANEL_COMMUNICATION_RESTORE = 'PanelCommunicationRestore';
    /**
     * Constant for value 'NotRespondingRestore'
     * @return string 'NotRespondingRestore'
     */
    const VALUE_NOT_RESPONDING_RESTORE = 'NotRespondingRestore';
    /**
     * Constant for value 'SuccessfulWebsiteLogin'
     * @return string 'SuccessfulWebsiteLogin'
     */
    const VALUE_SUCCESSFUL_WEBSITE_LOGIN = 'SuccessfulWebsiteLogin';
    /**
     * Constant for value 'FailedWebsiteLogin'
     * @return string 'FailedWebsiteLogin'
     */
    const VALUE_FAILED_WEBSITE_LOGIN = 'FailedWebsiteLogin';
    /**
     * Constant for value 'SensorTestStart'
     * @return string 'SensorTestStart'
     */
    const VALUE_SENSOR_TEST_START = 'SensorTestStart';
    /**
     * Constant for value 'SensorTestEnd'
     * @return string 'SensorTestEnd'
     */
    const VALUE_SENSOR_TEST_END = 'SensorTestEnd';
    /**
     * Constant for value 'EntryDelayTrouble'
     * @return string 'EntryDelayTrouble'
     */
    const VALUE_ENTRY_DELAY_TROUBLE = 'EntryDelayTrouble';
    /**
     * Constant for value 'PolicePanicPendingAlarm'
     * @return string 'PolicePanicPendingAlarm'
     */
    const VALUE_POLICE_PANIC_PENDING_ALARM = 'PolicePanicPendingAlarm';
    /**
     * Constant for value 'AuxPanicPendingAlarm'
     * @return string 'AuxPanicPendingAlarm'
     */
    const VALUE_AUX_PANIC_PENDING_ALARM = 'AuxPanicPendingAlarm';
    /**
     * Constant for value 'PendingAlarm'
     * @return string 'PendingAlarm'
     */
    const VALUE_PENDING_ALARM = 'PendingAlarm';
    /**
     * Constant for value 'SuspectedEntryDelayAlarm'
     * @return string 'SuspectedEntryDelayAlarm'
     */
    const VALUE_SUSPECTED_ENTRY_DELAY_ALARM = 'SuspectedEntryDelayAlarm';
    /**
     * Constant for value 'PolicePanicSuspectedAlarm'
     * @return string 'PolicePanicSuspectedAlarm'
     */
    const VALUE_POLICE_PANIC_SUSPECTED_ALARM = 'PolicePanicSuspectedAlarm';
    /**
     * Constant for value 'AuxPanicSuspectedAlarm'
     * @return string 'AuxPanicSuspectedAlarm'
     */
    const VALUE_AUX_PANIC_SUSPECTED_ALARM = 'AuxPanicSuspectedAlarm';
    /**
     * Constant for value 'SuspectedAlarm'
     * @return string 'SuspectedAlarm'
     */
    const VALUE_SUSPECTED_ALARM = 'SuspectedAlarm';
    /**
     * Constant for value 'ReceiverJammed'
     * @return string 'ReceiverJammed'
     */
    const VALUE_RECEIVER_JAMMED = 'ReceiverJammed';
    /**
     * Constant for value 'SirenTamper'
     * @return string 'SirenTamper'
     */
    const VALUE_SIREN_TAMPER = 'SirenTamper';
    /**
     * Constant for value 'SirenTamperRestore'
     * @return string 'SirenTamperRestore'
     */
    const VALUE_SIREN_TAMPER_RESTORE = 'SirenTamperRestore';
    /**
     * Constant for value 'TwoTripError'
     * @return string 'TwoTripError'
     */
    const VALUE_TWO_TRIP_ERROR = 'TwoTripError';
    /**
     * Constant for value 'VideoEvent'
     * @return string 'VideoEvent'
     */
    const VALUE_VIDEO_EVENT = 'VideoEvent';
    /**
     * Constant for value 'SensorRestore'
     * @return string 'SensorRestore'
     */
    const VALUE_SENSOR_RESTORE = 'SensorRestore';
    /**
     * Constant for value 'SilentPolicePanic'
     * @return string 'SilentPolicePanic'
     */
    const VALUE_SILENT_POLICE_PANIC = 'SilentPolicePanic';
    /**
     * Constant for value 'ArmingReminder'
     * @return string 'ArmingReminder'
     */
    const VALUE_ARMING_REMINDER = 'ArmingReminder';
    /**
     * Constant for value 'SensorLeftOpen'
     * @return string 'SensorLeftOpen'
     */
    const VALUE_SENSOR_LEFT_OPEN = 'SensorLeftOpen';
    /**
     * Constant for value 'VideoUpload'
     * @return string 'VideoUpload'
     */
    const VALUE_VIDEO_UPLOAD = 'VideoUpload';
    /**
     * Constant for value 'EndOfReceiverJammed'
     * @return string 'EndOfReceiverJammed'
     */
    const VALUE_END_OF_RECEIVER_JAMMED = 'EndOfReceiverJammed';
    /**
     * Constant for value 'CameraAccessTestOk'
     * @return string 'CameraAccessTestOk'
     */
    const VALUE_CAMERA_ACCESS_TEST_OK = 'CameraAccessTestOk';
    /**
     * Constant for value 'CameraAccessTestFail'
     * @return string 'CameraAccessTestFail'
     */
    const VALUE_CAMERA_ACCESS_TEST_FAIL = 'CameraAccessTestFail';
    /**
     * Constant for value 'CameraFailedState'
     * @return string 'CameraFailedState'
     */
    const VALUE_CAMERA_FAILED_STATE = 'CameraFailedState';
    /**
     * Constant for value 'CameraRestored'
     * @return string 'CameraRestored'
     */
    const VALUE_CAMERA_RESTORED = 'CameraRestored';
    /**
     * Constant for value 'UploadsOver50percent'
     * @return string 'UploadsOver50percent'
     */
    const VALUE_UPLOADS_OVER_50_PERCENT = 'UploadsOver50percent';
    /**
     * Constant for value 'UploadsOver90percent'
     * @return string 'UploadsOver90percent'
     */
    const VALUE_UPLOADS_OVER_90_PERCENT = 'UploadsOver90percent';
    /**
     * Constant for value 'UploadsOverQuota'
     * @return string 'UploadsOverQuota'
     */
    const VALUE_UPLOADS_OVER_QUOTA = 'UploadsOverQuota';
    /**
     * Constant for value 'UploadsQuotaCleared'
     * @return string 'UploadsQuotaCleared'
     */
    const VALUE_UPLOADS_QUOTA_CLEARED = 'UploadsQuotaCleared';
    /**
     * Constant for value 'MedicationAlert'
     * @return string 'MedicationAlert'
     */
    const VALUE_MEDICATION_ALERT = 'MedicationAlert';
    /**
     * Constant for value 'LackOfUsage'
     * @return string 'LackOfUsage'
     */
    const VALUE_LACK_OF_USAGE = 'LackOfUsage';
    /**
     * Constant for value 'LatchkeyNotification'
     * @return string 'LatchkeyNotification'
     */
    const VALUE_LATCHKEY_NOTIFICATION = 'LatchkeyNotification';
    /**
     * Constant for value 'LatchkeyArmingReminder'
     * @return string 'LatchkeyArmingReminder'
     */
    const VALUE_LATCHKEY_ARMING_REMINDER = 'LatchkeyArmingReminder';
    /**
     * Constant for value 'DoorUnlocked'
     * @return string 'DoorUnlocked'
     */
    const VALUE_DOOR_UNLOCKED = 'DoorUnlocked';
    /**
     * Constant for value 'DoorLocked'
     * @return string 'DoorLocked'
     */
    const VALUE_DOOR_LOCKED = 'DoorLocked';
    /**
     * Constant for value 'DoorAccessed'
     * @return string 'DoorAccessed'
     */
    const VALUE_DOOR_ACCESSED = 'DoorAccessed';
    /**
     * Constant for value 'BadLockUserCode'
     * @return string 'BadLockUserCode'
     */
    const VALUE_BAD_LOCK_USER_CODE = 'BadLockUserCode';
    /**
     * Constant for value 'ThermostatSetPointChanged'
     * @return string 'ThermostatSetPointChanged'
     */
    const VALUE_THERMOSTAT_SET_POINT_CHANGED = 'ThermostatSetPointChanged';
    /**
     * Constant for value 'ThermostatModeChanged'
     * @return string 'ThermostatModeChanged'
     */
    const VALUE_THERMOSTAT_MODE_CHANGED = 'ThermostatModeChanged';
    /**
     * Constant for value 'TemperatureRestoral'
     * @return string 'TemperatureRestoral'
     */
    const VALUE_TEMPERATURE_RESTORAL = 'TemperatureRestoral';
    /**
     * Constant for value 'UserTriggeredVideo'
     * @return string 'UserTriggeredVideo'
     */
    const VALUE_USER_TRIGGERED_VIDEO = 'UserTriggeredVideo';
    /**
     * Constant for value 'Reminder'
     * @return string 'Reminder'
     */
    const VALUE_REMINDER = 'Reminder';
    /**
     * Constant for value 'ImageSensorUpload'
     * @return string 'ImageSensorUpload'
     */
    const VALUE_IMAGE_SENSOR_UPLOAD = 'ImageSensorUpload';
    /**
     * Constant for value 'OpenedClosed'
     * @return string 'OpenedClosed'
     */
    const VALUE_OPENED_CLOSED = 'OpenedClosed';
    /**
     * Constant for value 'SensorLeftOpenRule'
     * @return string 'SensorLeftOpenRule'
     */
    const VALUE_SENSOR_LEFT_OPEN_RULE = 'SensorLeftOpenRule';
    /**
     * Constant for value 'SensorLeftClosed'
     * @return string 'SensorLeftClosed'
     */
    const VALUE_SENSOR_LEFT_CLOSED = 'SensorLeftClosed';
    /**
     * Constant for value 'SensorLeftOpenRestoral'
     * @return string 'SensorLeftOpenRestoral'
     */
    const VALUE_SENSOR_LEFT_OPEN_RESTORAL = 'SensorLeftOpenRestoral';
    /**
     * Constant for value 'SensorLeftClosedRestoral'
     * @return string 'SensorLeftClosedRestoral'
     */
    const VALUE_SENSOR_LEFT_CLOSED_RESTORAL = 'SensorLeftClosedRestoral';
    /**
     * Constant for value 'ThermostatOffset'
     * @return string 'ThermostatOffset'
     */
    const VALUE_THERMOSTAT_OFFSET = 'ThermostatOffset';
    /**
     * Constant for value 'IDProtectionEvent'
     * @return string 'IDProtectionEvent'
     */
    const VALUE_IDPROTECTION_EVENT = 'IDProtectionEvent';
    /**
     * Constant for value 'UsageGoalAlert'
     * @return string 'UsageGoalAlert'
     */
    const VALUE_USAGE_GOAL_ALERT = 'UsageGoalAlert';
    /**
     * Constant for value 'SilentAlarm'
     * @return string 'SilentAlarm'
     */
    const VALUE_SILENT_ALARM = 'SilentAlarm';
    /**
     * Constant for value 'TamperPendingAlarm'
     * @return string 'TamperPendingAlarm'
     */
    const VALUE_TAMPER_PENDING_ALARM = 'TamperPendingAlarm';
    /**
     * Constant for value 'TamperSuspectedAlarm'
     * @return string 'TamperSuspectedAlarm'
     */
    const VALUE_TAMPER_SUSPECTED_ALARM = 'TamperSuspectedAlarm';
    /**
     * Constant for value 'FirePanicPendingAlarm'
     * @return string 'FirePanicPendingAlarm'
     */
    const VALUE_FIRE_PANIC_PENDING_ALARM = 'FirePanicPendingAlarm';
    /**
     * Constant for value 'FirePanicSuspectedAlarm'
     * @return string 'FirePanicSuspectedAlarm'
     */
    const VALUE_FIRE_PANIC_SUSPECTED_ALARM = 'FirePanicSuspectedAlarm';
    /**
     * Constant for value 'ArmedNight'
     * @return string 'ArmedNight'
     */
    const VALUE_ARMED_NIGHT = 'ArmedNight';
    /**
     * Constant for value 'SumpPumpAlertNormalOperation'
     * @return string 'SumpPumpAlertNormalOperation'
     */
    const VALUE_SUMP_PUMP_ALERT_NORMAL_OPERATION = 'SumpPumpAlertNormalOperation';
    /**
     * Constant for value 'SumpPumpAlertPossibleIssue'
     * @return string 'SumpPumpAlertPossibleIssue'
     */
    const VALUE_SUMP_PUMP_ALERT_POSSIBLE_ISSUE = 'SumpPumpAlertPossibleIssue';
    /**
     * Constant for value 'SumpPumpAlertCriticalIssueOff'
     * @return string 'SumpPumpAlertCriticalIssueOff'
     */
    const VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_OFF = 'SumpPumpAlertCriticalIssueOff';
    /**
     * Constant for value 'SumpPumpAlertCriticalIssueMalfunction'
     * @return string 'SumpPumpAlertCriticalIssueMalfunction'
     */
    const VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_MALFUNCTION = 'SumpPumpAlertCriticalIssueMalfunction';
    /**
     * Constant for value 'ThermostatFanModeChanged'
     * @return string 'ThermostatFanModeChanged'
     */
    const VALUE_THERMOSTAT_FAN_MODE_CHANGED = 'ThermostatFanModeChanged';
    /**
     * Constant for value 'ThermostatSensorLeftOpenOffset'
     * @return string 'ThermostatSensorLeftOpenOffset'
     */
    const VALUE_THERMOSTAT_SENSOR_LEFT_OPEN_OFFSET = 'ThermostatSensorLeftOpenOffset';
    /**
     * Constant for value 'CommercialEarlyOpen'
     * @return string 'CommercialEarlyOpen'
     */
    const VALUE_COMMERCIAL_EARLY_OPEN = 'CommercialEarlyOpen';
    /**
     * Constant for value 'CommercialLateOpen'
     * @return string 'CommercialLateOpen'
     */
    const VALUE_COMMERCIAL_LATE_OPEN = 'CommercialLateOpen';
    /**
     * Constant for value 'CommercialOpenOnTime'
     * @return string 'CommercialOpenOnTime'
     */
    const VALUE_COMMERCIAL_OPEN_ON_TIME = 'CommercialOpenOnTime';
    /**
     * Constant for value 'CommercialEarlyClose'
     * @return string 'CommercialEarlyClose'
     */
    const VALUE_COMMERCIAL_EARLY_CLOSE = 'CommercialEarlyClose';
    /**
     * Constant for value 'CommercialLateClose'
     * @return string 'CommercialLateClose'
     */
    const VALUE_COMMERCIAL_LATE_CLOSE = 'CommercialLateClose';
    /**
     * Constant for value 'CommercialClosedOnTime'
     * @return string 'CommercialClosedOnTime'
     */
    const VALUE_COMMERCIAL_CLOSED_ON_TIME = 'CommercialClosedOnTime';
    /**
     * Constant for value 'ImageUploadsOverQuota'
     * @return string 'ImageUploadsOverQuota'
     */
    const VALUE_IMAGE_UPLOADS_OVER_QUOTA = 'ImageUploadsOverQuota';
    /**
     * Constant for value 'SmsOverQuota'
     * @return string 'SmsOverQuota'
     */
    const VALUE_SMS_OVER_QUOTA = 'SmsOverQuota';
    /**
     * Constant for value 'DeviceFailedToSecure'
     * @return string 'DeviceFailedToSecure'
     */
    const VALUE_DEVICE_FAILED_TO_SECURE = 'DeviceFailedToSecure';
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'EndOfDisabled'
     * @return string 'EndOfDisabled'
     */
    const VALUE_END_OF_DISABLED = 'EndOfDisabled';
    /**
     * Constant for value 'SentEmail'
     * @return string 'SentEmail'
     */
    const VALUE_SENT_EMAIL = 'SentEmail';
    /**
     * Constant for value 'Ok'
     * @return string 'Ok'
     */
    const VALUE_OK = 'Ok';
    /**
     * Constant for value 'Issue'
     * @return string 'Issue'
     */
    const VALUE_ISSUE = 'Issue';
    /**
     * Constant for value 'DoorbellButtonPress'
     * @return string 'DoorbellButtonPress'
     */
    const VALUE_DOORBELL_BUTTON_PRESS = 'DoorbellButtonPress';
    /**
     * Constant for value 'LowFuel'
     * @return string 'LowFuel'
     */
    const VALUE_LOW_FUEL = 'LowFuel';
    /**
     * Constant for value 'FuelOK'
     * @return string 'FuelOK'
     */
    const VALUE_FUEL_OK = 'FuelOK';
    /**
     * Constant for value 'AccessCardScanned'
     * @return string 'AccessCardScanned'
     */
    const VALUE_ACCESS_CARD_SCANNED = 'AccessCardScanned';
    /**
     * Constant for value 'ExitButtonPressed'
     * @return string 'ExitButtonPressed'
     */
    const VALUE_EXIT_BUTTON_PRESSED = 'ExitButtonPressed';
    /**
     * Constant for value 'CarLowBattery'
     * @return string 'CarLowBattery'
     */
    const VALUE_CAR_LOW_BATTERY = 'CarLowBattery';
    /**
     * Constant for value 'CarBatteryOK'
     * @return string 'CarBatteryOK'
     */
    const VALUE_CAR_BATTERY_OK = 'CarBatteryOK';
    /**
     * Constant for value 'CarConnectorNotResponding'
     * @return string 'CarConnectorNotResponding'
     */
    const VALUE_CAR_CONNECTOR_NOT_RESPONDING = 'CarConnectorNotResponding';
    /**
     * Constant for value 'CarConnectorCommunicationRestored'
     * @return string 'CarConnectorCommunicationRestored'
     */
    const VALUE_CAR_CONNECTOR_COMMUNICATION_RESTORED = 'CarConnectorCommunicationRestored';
    /**
     * Constant for value 'CarDiagnosticIssueReported'
     * @return string 'CarDiagnosticIssueReported'
     */
    const VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED = 'CarDiagnosticIssueReported';
    /**
     * Constant for value 'CarDiagnosticIssueCleared'
     * @return string 'CarDiagnosticIssueCleared'
     */
    const VALUE_CAR_DIAGNOSTIC_ISSUE_CLEARED = 'CarDiagnosticIssueCleared';
    /**
     * Constant for value 'CarUnexpectedMovementAlarm'
     * @return string 'CarUnexpectedMovementAlarm'
     */
    const VALUE_CAR_UNEXPECTED_MOVEMENT_ALARM = 'CarUnexpectedMovementAlarm';
    /**
     * Constant for value 'CarHighSpeedAlert'
     * @return string 'CarHighSpeedAlert'
     */
    const VALUE_CAR_HIGH_SPEED_ALERT = 'CarHighSpeedAlert';
    /**
     * Constant for value 'CarHardAccelerationAlert'
     * @return string 'CarHardAccelerationAlert'
     */
    const VALUE_CAR_HARD_ACCELERATION_ALERT = 'CarHardAccelerationAlert';
    /**
     * Constant for value 'CarHardBrakeAlert'
     * @return string 'CarHardBrakeAlert'
     */
    const VALUE_CAR_HARD_BRAKE_ALERT = 'CarHardBrakeAlert';
    /**
     * Constant for value 'WaterLeakAlert'
     * @return string 'WaterLeakAlert'
     */
    const VALUE_WATER_LEAK_ALERT = 'WaterLeakAlert';
    /**
     * Constant for value 'ExtendedWaterUsageAlert'
     * @return string 'ExtendedWaterUsageAlert'
     */
    const VALUE_EXTENDED_WATER_USAGE_ALERT = 'ExtendedWaterUsageAlert';
    /**
     * Constant for value 'WaterLeakOrExtendedWaterUsageRestoral'
     * @return string 'WaterLeakOrExtendedWaterUsageRestoral'
     */
    const VALUE_WATER_LEAK_OR_EXTENDED_WATER_USAGE_RESTORAL = 'WaterLeakOrExtendedWaterUsageRestoral';
    /**
     * Constant for value 'CellDoorTamper'
     * @return string 'CellDoorTamper'
     */
    const VALUE_CELL_DOOR_TAMPER = 'CellDoorTamper';
    /**
     * Constant for value 'EndOfCellDoorTamper'
     * @return string 'EndOfCellDoorTamper'
     */
    const VALUE_END_OF_CELL_DOOR_TAMPER = 'EndOfCellDoorTamper';
    /**
     * Constant for value 'ReceiverJammedAlarm'
     * @return string 'ReceiverJammedAlarm'
     */
    const VALUE_RECEIVER_JAMMED_ALARM = 'ReceiverJammedAlarm';
    /**
     * Constant for value 'ViewedByCentralStation'
     * @return string 'ViewedByCentralStation'
     */
    const VALUE_VIEWED_BY_CENTRAL_STATION = 'ViewedByCentralStation';
    /**
     * Constant for value 'OSnappAlarmUpdated'
     * @return string 'OSnappAlarmUpdated'
     */
    const VALUE_OSNAPP_ALARM_UPDATED = 'OSnappAlarmUpdated';
    /**
     * Constant for value 'OSnappForwardAlarmToCs'
     * @return string 'OSnappForwardAlarmToCs'
     */
    const VALUE_OSNAPP_FORWARD_ALARM_TO_CS = 'OSnappForwardAlarmToCs';
    /**
     * Constant for value 'OSnappLocationReport'
     * @return string 'OSnappLocationReport'
     */
    const VALUE_OSNAPP_LOCATION_REPORT = 'OSnappLocationReport';
    /**
     * Constant for value 'OSnappForwardLocationToCs'
     * @return string 'OSnappForwardLocationToCs'
     */
    const VALUE_OSNAPP_FORWARD_LOCATION_TO_CS = 'OSnappForwardLocationToCs';
    /**
     * Constant for value 'ButtonPressed'
     * @return string 'ButtonPressed'
     */
    const VALUE_BUTTON_PRESSED = 'ButtonPressed';
    /**
     * Constant for value 'OSnappNotificationSent'
     * @return string 'OSnappNotificationSent'
     */
    const VALUE_OSNAPP_NOTIFICATION_SENT = 'OSnappNotificationSent';
    /**
     * Constant for value 'DoorbellCallRequest'
     * @return string 'DoorbellCallRequest'
     */
    const VALUE_DOORBELL_CALL_REQUEST = 'DoorbellCallRequest';
    /**
     * Constant for value 'CarUnexpectedMovementLocationAlarm'
     * @return string 'CarUnexpectedMovementLocationAlarm'
     */
    const VALUE_CAR_UNEXPECTED_MOVEMENT_LOCATION_ALARM = 'CarUnexpectedMovementLocationAlarm';
    /**
     * Constant for value 'EndofCarUnexpectedMovementAlarm'
     * @return string 'EndofCarUnexpectedMovementAlarm'
     */
    const VALUE_ENDOF_CAR_UNEXPECTED_MOVEMENT_ALARM = 'EndofCarUnexpectedMovementAlarm';
    /**
     * Constant for value 'EthernetUnpluggedEvent'
     * @return string 'EthernetUnpluggedEvent'
     */
    const VALUE_ETHERNET_UNPLUGGED_EVENT = 'EthernetUnpluggedEvent';
    /**
     * Constant for value 'EthernetPluggedInEvent'
     * @return string 'EthernetPluggedInEvent'
     */
    const VALUE_ETHERNET_PLUGGED_IN_EVENT = 'EthernetPluggedInEvent';
    /**
     * Constant for value 'KeypadLockedOutEvent'
     * @return string 'KeypadLockedOutEvent'
     */
    const VALUE_KEYPAD_LOCKED_OUT_EVENT = 'KeypadLockedOutEvent';
    /**
     * Constant for value 'SilentPolicePanicPendingAlarm'
     * @return string 'SilentPolicePanicPendingAlarm'
     */
    const VALUE_SILENT_POLICE_PANIC_PENDING_ALARM = 'SilentPolicePanicPendingAlarm';
    /**
     * Constant for value 'SilentPolicePanicSuspectedAlarm'
     * @return string 'SilentPolicePanicSuspectedAlarm'
     */
    const VALUE_SILENT_POLICE_PANIC_SUSPECTED_ALARM = 'SilentPolicePanicSuspectedAlarm';
    /**
     * Constant for value 'CarMonitorPluggedIn'
     * @return string 'CarMonitorPluggedIn'
     */
    const VALUE_CAR_MONITOR_PLUGGED_IN = 'CarMonitorPluggedIn';
    /**
     * Constant for value 'SystemDateTimeChanged'
     * @return string 'SystemDateTimeChanged'
     */
    const VALUE_SYSTEM_DATE_TIME_CHANGED = 'SystemDateTimeChanged';
    /**
     * Constant for value 'CommercialClosedUnexpectedly'
     * @return string 'CommercialClosedUnexpectedly'
     */
    const VALUE_COMMERCIAL_CLOSED_UNEXPECTEDLY = 'CommercialClosedUnexpectedly';
    /**
     * Constant for value 'ContinuousCloudReceiverStarted'
     * @return string 'ContinuousCloudReceiverStarted'
     */
    const VALUE_CONTINUOUS_CLOUD_RECEIVER_STARTED = 'ContinuousCloudReceiverStarted';
    /**
     * Constant for value 'ContinuousCloudReceiverStopped'
     * @return string 'ContinuousCloudReceiverStopped'
     */
    const VALUE_CONTINUOUS_CLOUD_RECEIVER_STOPPED = 'ContinuousCloudReceiverStopped';
    /**
     * Constant for value 'DoorFailedAccess'
     * @return string 'DoorFailedAccess'
     */
    const VALUE_DOOR_FAILED_ACCESS = 'DoorFailedAccess';
    /**
     * Constant for value 'DoorForcedOpen'
     * @return string 'DoorForcedOpen'
     */
    const VALUE_DOOR_FORCED_OPEN = 'DoorForcedOpen';
    /**
     * Constant for value 'DoorBuzzedFromWebsite'
     * @return string 'DoorBuzzedFromWebsite'
     */
    const VALUE_DOOR_BUZZED_FROM_WEBSITE = 'DoorBuzzedFromWebsite';
    /**
     * Constant for value 'SiteSpecificDataAltered'
     * @return string 'SiteSpecificDataAltered'
     */
    const VALUE_SITE_SPECIFIC_DATA_ALTERED = 'SiteSpecificDataAltered';
    /**
     * Constant for value 'DoorHeldOpen'
     * @return string 'DoorHeldOpen'
     */
    const VALUE_DOOR_HELD_OPEN = 'DoorHeldOpen';
    /**
     * Constant for value 'UnknownCardFormatRead'
     * @return string 'UnknownCardFormatRead'
     */
    const VALUE_UNKNOWN_CARD_FORMAT_READ = 'UnknownCardFormatRead';
    /**
     * Constant for value 'QuickExit'
     * @return string 'QuickExit'
     */
    const VALUE_QUICK_EXIT = 'QuickExit';
    /**
     * Constant for value 'DoorBuzzCommandSent'
     * @return string 'DoorBuzzCommandSent'
     */
    const VALUE_DOOR_BUZZ_COMMAND_SENT = 'DoorBuzzCommandSent';
    /**
     * Constant for value 'UnlockCommandSent'
     * @return string 'UnlockCommandSent'
     */
    const VALUE_UNLOCK_COMMAND_SENT = 'UnlockCommandSent';
    /**
     * Constant for value 'LockCommandSent'
     * @return string 'LockCommandSent'
     */
    const VALUE_LOCK_COMMAND_SENT = 'LockCommandSent';
    /**
     * Constant for value 'PGM2FireTrouble'
     * @return string 'PGM2FireTrouble'
     */
    const VALUE_PGM_2_FIRE_TROUBLE = 'PGM2FireTrouble';
    /**
     * Constant for value 'EndOfPGM2FireTrouble'
     * @return string 'EndOfPGM2FireTrouble'
     */
    const VALUE_END_OF_PGM_2_FIRE_TROUBLE = 'EndOfPGM2FireTrouble';
    /**
     * Constant for value 'OVLBasic'
     * @return string 'OVLBasic'
     */
    const VALUE_OVLBASIC = 'OVLBasic';
    /**
     * Constant for value 'OVLAdvanced'
     * @return string 'OVLAdvanced'
     */
    const VALUE_OVLADVANCED = 'OVLAdvanced';
    /**
     * Constant for value 'SpecialEventModemPowerUp'
     * @return string 'SpecialEventModemPowerUp'
     */
    const VALUE_SPECIAL_EVENT_MODEM_POWER_UP = 'SpecialEventModemPowerUp';
    /**
     * Constant for value 'SpecialEventModemPanelCommError'
     * @return string 'SpecialEventModemPanelCommError'
     */
    const VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_ERROR = 'SpecialEventModemPanelCommError';
    /**
     * Constant for value 'SpecialEventModemPanelCommOK'
     * @return string 'SpecialEventModemPanelCommOK'
     */
    const VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_OK = 'SpecialEventModemPanelCommOK';
    /**
     * Constant for value 'SpecialEventCodeLockSettingIsOn'
     * @return string 'SpecialEventCodeLockSettingIsOn'
     */
    const VALUE_SPECIAL_EVENT_CODE_LOCK_SETTING_IS_ON = 'SpecialEventCodeLockSettingIsOn';
    /**
     * Constant for value 'SpecialEventMalfunction'
     * @return string 'SpecialEventMalfunction'
     */
    const VALUE_SPECIAL_EVENT_MALFUNCTION = 'SpecialEventMalfunction';
    /**
     * Constant for value 'SpecialEventTamper'
     * @return string 'SpecialEventTamper'
     */
    const VALUE_SPECIAL_EVENT_TAMPER = 'SpecialEventTamper';
    /**
     * Constant for value 'SpecialEventNoMessagesFromSkytelInLast50Cycles'
     * @return string 'SpecialEventNoMessagesFromSkytelInLast50Cycles'
     */
    const VALUE_SPECIAL_EVENT_NO_MESSAGES_FROM_SKYTEL_IN_LAST_50_CYCLES = 'SpecialEventNoMessagesFromSkytelInLast50Cycles';
    /**
     * Constant for value 'SpecialEventExcessiveOldMessagesInSkytelMailbox'
     * @return string 'SpecialEventExcessiveOldMessagesInSkytelMailbox'
     */
    const VALUE_SPECIAL_EVENT_EXCESSIVE_OLD_MESSAGES_IN_SKYTEL_MAILBOX = 'SpecialEventExcessiveOldMessagesInSkytelMailbox';
    /**
     * Constant for value 'SpecialEventModemEncryptionFailure'
     * @return string 'SpecialEventModemEncryptionFailure'
     */
    const VALUE_SPECIAL_EVENT_MODEM_ENCRYPTION_FAILURE = 'SpecialEventModemEncryptionFailure';
    /**
     * Constant for value 'SpecialEventServicePlanAttemptfailure'
     * @return string 'SpecialEventServicePlanAttemptfailure'
     */
    const VALUE_SPECIAL_EVENT_SERVICE_PLAN_ATTEMPTFAILURE = 'SpecialEventServicePlanAttemptfailure';
    /**
     * Constant for value 'SpecialEventUnitCommandMaxReached'
     * @return string 'SpecialEventUnitCommandMaxReached'
     */
    const VALUE_SPECIAL_EVENT_UNIT_COMMAND_MAX_REACHED = 'SpecialEventUnitCommandMaxReached';
    /**
     * Constant for value 'SpecialEventBlockCountExceeded'
     * @return string 'SpecialEventBlockCountExceeded'
     */
    const VALUE_SPECIAL_EVENT_BLOCK_COUNT_EXCEEDED = 'SpecialEventBlockCountExceeded';
    /**
     * Constant for value 'SpecialEventNotResponding'
     * @return string 'SpecialEventNotResponding'
     */
    const VALUE_SPECIAL_EVENT_NOT_RESPONDING = 'SpecialEventNotResponding';
    /**
     * Constant for value 'SpecialEventRadioOff'
     * @return string 'SpecialEventRadioOff'
     */
    const VALUE_SPECIAL_EVENT_RADIO_OFF = 'SpecialEventRadioOff';
    /**
     * Constant for value 'SpecialEventRadioRestored'
     * @return string 'SpecialEventRadioRestored'
     */
    const VALUE_SPECIAL_EVENT_RADIO_RESTORED = 'SpecialEventRadioRestored';
    /**
     * Constant for value 'SpecialEventLowModemSignalLevel'
     * @return string 'SpecialEventLowModemSignalLevel'
     */
    const VALUE_SPECIAL_EVENT_LOW_MODEM_SIGNAL_LEVEL = 'SpecialEventLowModemSignalLevel';
    /**
     * Constant for value 'SpecialEventPanelPowerFailure'
     * @return string 'SpecialEventPanelPowerFailure'
     */
    const VALUE_SPECIAL_EVENT_PANEL_POWER_FAILURE = 'SpecialEventPanelPowerFailure';
    /**
     * Constant for value 'SpecialEventPanelPowerRestored'
     * @return string 'SpecialEventPanelPowerRestored'
     */
    const VALUE_SPECIAL_EVENT_PANEL_POWER_RESTORED = 'SpecialEventPanelPowerRestored';
    /**
     * Constant for value 'SpecialEventLowBattery'
     * @return string 'SpecialEventLowBattery'
     */
    const VALUE_SPECIAL_EVENT_LOW_BATTERY = 'SpecialEventLowBattery';
    /**
     * Constant for value 'SpecialEventCameraFailedState'
     * @return string 'SpecialEventCameraFailedState'
     */
    const VALUE_SPECIAL_EVENT_CAMERA_FAILED_STATE = 'SpecialEventCameraFailedState';
    /**
     * Constant for value 'SpecialEventCameraConnectionRestored'
     * @return string 'SpecialEventCameraConnectionRestored'
     */
    const VALUE_SPECIAL_EVENT_CAMERA_CONNECTION_RESTORED = 'SpecialEventCameraConnectionRestored';
    /**
     * Constant for value 'SpecialEventUploadsOverQuota'
     * @return string 'SpecialEventUploadsOverQuota'
     */
    const VALUE_SPECIAL_EVENT_UPLOADS_OVER_QUOTA = 'SpecialEventUploadsOverQuota';
    /**
     * Constant for value 'SpecialEventNotRespondingRestore'
     * @return string 'SpecialEventNotRespondingRestore'
     */
    const VALUE_SPECIAL_EVENT_NOT_RESPONDING_RESTORE = 'SpecialEventNotRespondingRestore';
    /**
     * Constant for value 'SpecialEventWaterAlert'
     * @return string 'SpecialEventWaterAlert'
     */
    const VALUE_SPECIAL_EVENT_WATER_ALERT = 'SpecialEventWaterAlert';
    /**
     * Constant for value 'SpecialEventDryContact'
     * @return string 'SpecialEventDryContact'
     */
    const VALUE_SPECIAL_EVENT_DRY_CONTACT = 'SpecialEventDryContact';
    /**
     * Constant for value 'SpecialEventOilGauge'
     * @return string 'SpecialEventOilGauge'
     */
    const VALUE_SPECIAL_EVENT_OIL_GAUGE = 'SpecialEventOilGauge';
    /**
     * Constant for value 'SpecialEventPanelTamper'
     * @return string 'SpecialEventPanelTamper'
     */
    const VALUE_SPECIAL_EVENT_PANEL_TAMPER = 'SpecialEventPanelTamper';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_ALARM
     * @uses self::VALUE_VALUE
     * @uses self::VALUE_FIRE_ALARM
     * @uses self::VALUE_LOW_BATTERY
     * @uses self::VALUE_POWER_FAILURE
     * @uses self::VALUE_MALFUNCTION
     * @uses self::VALUE_TAMPER
     * @uses self::VALUE_DISARMED
     * @uses self::VALUE_ARMED_STAY
     * @uses self::VALUE_ARMED_AWAY
     * @uses self::VALUE_ARMING_FAILED
     * @uses self::VALUE_DISARMING_FAILED
     * @uses self::VALUE_BYPASSED
     * @uses self::VALUE_PROGRAMMED
     * @uses self::VALUE_OPENED
     * @uses self::VALUE_POWER_RESTORED
     * @uses self::VALUE_AUXILIARY_PANIC
     * @uses self::VALUE_DURESS
     * @uses self::VALUE_PHONE_LINE_FAILURE
     * @uses self::VALUE_PANEL_NOT_RESPONDING
     * @uses self::VALUE_TEMPERATURE_ALERT
     * @uses self::VALUE_POLICE_PANIC
     * @uses self::VALUE_CARBON_MONOXIDE
     * @uses self::VALUE_FIRE_PANIC
     * @uses self::VALUE_NO_ACTIVITY_ALARM
     * @uses self::VALUE_FLOOD_EXTREME_TEMP_ALARM
     * @uses self::VALUE_EXIT_FAULT
     * @uses self::VALUE_RECENT_ARMING
     * @uses self::VALUE_END_OF_TAMPERING
     * @uses self::VALUE_PHONE_LINE_RESTORED
     * @uses self::VALUE_END_OF_MALFUNCTION
     * @uses self::VALUE_KEYPAD_TAMPER_ALARM
     * @uses self::VALUE_TAMPER_ALARM
     * @uses self::VALUE_WATER_ALARM
     * @uses self::VALUE_END_OF_BYPASS
     * @uses self::VALUE_BATTERY_OK
     * @uses self::VALUE_MODULE_MALFUNCTION
     * @uses self::VALUE_RADIO_OFF
     * @uses self::VALUE_RADIO_RESTORED
     * @uses self::VALUE_END_OF_MODULE_MALFUNCTION
     * @uses self::VALUE_SILENT_ALARM_CLEAR
     * @uses self::VALUE_GE_SPECIAL_EVENT
     * @uses self::VALUE_INACTIVITY_FAULT
     * @uses self::VALUE_INACTIVITY_RESTORAL
     * @uses self::VALUE_DURESS_ALARM_CLEAR
     * @uses self::VALUE_CLEAR_ACTIVE_ALARMS
     * @uses self::VALUE_DISARMING_SUPERVISION_FAULT
     * @uses self::VALUE_ARMING_SUPERVISION_FAULT
     * @uses self::VALUE_AUTO_PHONE_TEST
     * @uses self::VALUE_MANUAL_PHONE_TEST
     * @uses self::VALUE_CS_FORWARDING_FAILURE
     * @uses self::VALUE_PANEL_COMMUNICATION_FAILURE
     * @uses self::VALUE_PANEL_COMMUNICATION_RESTORE
     * @uses self::VALUE_NOT_RESPONDING_RESTORE
     * @uses self::VALUE_SUCCESSFUL_WEBSITE_LOGIN
     * @uses self::VALUE_FAILED_WEBSITE_LOGIN
     * @uses self::VALUE_SENSOR_TEST_START
     * @uses self::VALUE_SENSOR_TEST_END
     * @uses self::VALUE_ENTRY_DELAY_TROUBLE
     * @uses self::VALUE_POLICE_PANIC_PENDING_ALARM
     * @uses self::VALUE_AUX_PANIC_PENDING_ALARM
     * @uses self::VALUE_PENDING_ALARM
     * @uses self::VALUE_SUSPECTED_ENTRY_DELAY_ALARM
     * @uses self::VALUE_POLICE_PANIC_SUSPECTED_ALARM
     * @uses self::VALUE_AUX_PANIC_SUSPECTED_ALARM
     * @uses self::VALUE_SUSPECTED_ALARM
     * @uses self::VALUE_RECEIVER_JAMMED
     * @uses self::VALUE_SIREN_TAMPER
     * @uses self::VALUE_SIREN_TAMPER_RESTORE
     * @uses self::VALUE_TWO_TRIP_ERROR
     * @uses self::VALUE_VIDEO_EVENT
     * @uses self::VALUE_SENSOR_RESTORE
     * @uses self::VALUE_SILENT_POLICE_PANIC
     * @uses self::VALUE_ARMING_REMINDER
     * @uses self::VALUE_SENSOR_LEFT_OPEN
     * @uses self::VALUE_VIDEO_UPLOAD
     * @uses self::VALUE_END_OF_RECEIVER_JAMMED
     * @uses self::VALUE_CAMERA_ACCESS_TEST_OK
     * @uses self::VALUE_CAMERA_ACCESS_TEST_FAIL
     * @uses self::VALUE_CAMERA_FAILED_STATE
     * @uses self::VALUE_CAMERA_RESTORED
     * @uses self::VALUE_UPLOADS_OVER_50_PERCENT
     * @uses self::VALUE_UPLOADS_OVER_90_PERCENT
     * @uses self::VALUE_UPLOADS_OVER_QUOTA
     * @uses self::VALUE_UPLOADS_QUOTA_CLEARED
     * @uses self::VALUE_MEDICATION_ALERT
     * @uses self::VALUE_LACK_OF_USAGE
     * @uses self::VALUE_LATCHKEY_NOTIFICATION
     * @uses self::VALUE_LATCHKEY_ARMING_REMINDER
     * @uses self::VALUE_DOOR_UNLOCKED
     * @uses self::VALUE_DOOR_LOCKED
     * @uses self::VALUE_DOOR_ACCESSED
     * @uses self::VALUE_BAD_LOCK_USER_CODE
     * @uses self::VALUE_THERMOSTAT_SET_POINT_CHANGED
     * @uses self::VALUE_THERMOSTAT_MODE_CHANGED
     * @uses self::VALUE_TEMPERATURE_RESTORAL
     * @uses self::VALUE_USER_TRIGGERED_VIDEO
     * @uses self::VALUE_REMINDER
     * @uses self::VALUE_IMAGE_SENSOR_UPLOAD
     * @uses self::VALUE_OPENED_CLOSED
     * @uses self::VALUE_SENSOR_LEFT_OPEN_RULE
     * @uses self::VALUE_SENSOR_LEFT_CLOSED
     * @uses self::VALUE_SENSOR_LEFT_OPEN_RESTORAL
     * @uses self::VALUE_SENSOR_LEFT_CLOSED_RESTORAL
     * @uses self::VALUE_THERMOSTAT_OFFSET
     * @uses self::VALUE_IDPROTECTION_EVENT
     * @uses self::VALUE_USAGE_GOAL_ALERT
     * @uses self::VALUE_SILENT_ALARM
     * @uses self::VALUE_TAMPER_PENDING_ALARM
     * @uses self::VALUE_TAMPER_SUSPECTED_ALARM
     * @uses self::VALUE_FIRE_PANIC_PENDING_ALARM
     * @uses self::VALUE_FIRE_PANIC_SUSPECTED_ALARM
     * @uses self::VALUE_ARMED_NIGHT
     * @uses self::VALUE_SUMP_PUMP_ALERT_NORMAL_OPERATION
     * @uses self::VALUE_SUMP_PUMP_ALERT_POSSIBLE_ISSUE
     * @uses self::VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_OFF
     * @uses self::VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_MALFUNCTION
     * @uses self::VALUE_THERMOSTAT_FAN_MODE_CHANGED
     * @uses self::VALUE_THERMOSTAT_SENSOR_LEFT_OPEN_OFFSET
     * @uses self::VALUE_COMMERCIAL_EARLY_OPEN
     * @uses self::VALUE_COMMERCIAL_LATE_OPEN
     * @uses self::VALUE_COMMERCIAL_OPEN_ON_TIME
     * @uses self::VALUE_COMMERCIAL_EARLY_CLOSE
     * @uses self::VALUE_COMMERCIAL_LATE_CLOSE
     * @uses self::VALUE_COMMERCIAL_CLOSED_ON_TIME
     * @uses self::VALUE_IMAGE_UPLOADS_OVER_QUOTA
     * @uses self::VALUE_SMS_OVER_QUOTA
     * @uses self::VALUE_DEVICE_FAILED_TO_SECURE
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_END_OF_DISABLED
     * @uses self::VALUE_SENT_EMAIL
     * @uses self::VALUE_OK
     * @uses self::VALUE_ISSUE
     * @uses self::VALUE_DOORBELL_BUTTON_PRESS
     * @uses self::VALUE_LOW_FUEL
     * @uses self::VALUE_FUEL_OK
     * @uses self::VALUE_ACCESS_CARD_SCANNED
     * @uses self::VALUE_EXIT_BUTTON_PRESSED
     * @uses self::VALUE_CAR_LOW_BATTERY
     * @uses self::VALUE_CAR_BATTERY_OK
     * @uses self::VALUE_CAR_CONNECTOR_NOT_RESPONDING
     * @uses self::VALUE_CAR_CONNECTOR_COMMUNICATION_RESTORED
     * @uses self::VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED
     * @uses self::VALUE_CAR_DIAGNOSTIC_ISSUE_CLEARED
     * @uses self::VALUE_CAR_UNEXPECTED_MOVEMENT_ALARM
     * @uses self::VALUE_CAR_HIGH_SPEED_ALERT
     * @uses self::VALUE_CAR_HARD_ACCELERATION_ALERT
     * @uses self::VALUE_CAR_HARD_BRAKE_ALERT
     * @uses self::VALUE_WATER_LEAK_ALERT
     * @uses self::VALUE_EXTENDED_WATER_USAGE_ALERT
     * @uses self::VALUE_WATER_LEAK_OR_EXTENDED_WATER_USAGE_RESTORAL
     * @uses self::VALUE_CELL_DOOR_TAMPER
     * @uses self::VALUE_END_OF_CELL_DOOR_TAMPER
     * @uses self::VALUE_RECEIVER_JAMMED_ALARM
     * @uses self::VALUE_VIEWED_BY_CENTRAL_STATION
     * @uses self::VALUE_OSNAPP_ALARM_UPDATED
     * @uses self::VALUE_OSNAPP_FORWARD_ALARM_TO_CS
     * @uses self::VALUE_OSNAPP_LOCATION_REPORT
     * @uses self::VALUE_OSNAPP_FORWARD_LOCATION_TO_CS
     * @uses self::VALUE_BUTTON_PRESSED
     * @uses self::VALUE_OSNAPP_NOTIFICATION_SENT
     * @uses self::VALUE_DOORBELL_CALL_REQUEST
     * @uses self::VALUE_CAR_UNEXPECTED_MOVEMENT_LOCATION_ALARM
     * @uses self::VALUE_ENDOF_CAR_UNEXPECTED_MOVEMENT_ALARM
     * @uses self::VALUE_ETHERNET_UNPLUGGED_EVENT
     * @uses self::VALUE_ETHERNET_PLUGGED_IN_EVENT
     * @uses self::VALUE_KEYPAD_LOCKED_OUT_EVENT
     * @uses self::VALUE_SILENT_POLICE_PANIC_PENDING_ALARM
     * @uses self::VALUE_SILENT_POLICE_PANIC_SUSPECTED_ALARM
     * @uses self::VALUE_CAR_MONITOR_PLUGGED_IN
     * @uses self::VALUE_SYSTEM_DATE_TIME_CHANGED
     * @uses self::VALUE_COMMERCIAL_CLOSED_UNEXPECTEDLY
     * @uses self::VALUE_CONTINUOUS_CLOUD_RECEIVER_STARTED
     * @uses self::VALUE_CONTINUOUS_CLOUD_RECEIVER_STOPPED
     * @uses self::VALUE_DOOR_FAILED_ACCESS
     * @uses self::VALUE_DOOR_FORCED_OPEN
     * @uses self::VALUE_DOOR_BUZZED_FROM_WEBSITE
     * @uses self::VALUE_SITE_SPECIFIC_DATA_ALTERED
     * @uses self::VALUE_DOOR_HELD_OPEN
     * @uses self::VALUE_UNKNOWN_CARD_FORMAT_READ
     * @uses self::VALUE_QUICK_EXIT
     * @uses self::VALUE_DOOR_BUZZ_COMMAND_SENT
     * @uses self::VALUE_UNLOCK_COMMAND_SENT
     * @uses self::VALUE_LOCK_COMMAND_SENT
     * @uses self::VALUE_PGM_2_FIRE_TROUBLE
     * @uses self::VALUE_END_OF_PGM_2_FIRE_TROUBLE
     * @uses self::VALUE_OVLBASIC
     * @uses self::VALUE_OVLADVANCED
     * @uses self::VALUE_SPECIAL_EVENT_MODEM_POWER_UP
     * @uses self::VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_ERROR
     * @uses self::VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_OK
     * @uses self::VALUE_SPECIAL_EVENT_CODE_LOCK_SETTING_IS_ON
     * @uses self::VALUE_SPECIAL_EVENT_MALFUNCTION
     * @uses self::VALUE_SPECIAL_EVENT_TAMPER
     * @uses self::VALUE_SPECIAL_EVENT_NO_MESSAGES_FROM_SKYTEL_IN_LAST_50_CYCLES
     * @uses self::VALUE_SPECIAL_EVENT_EXCESSIVE_OLD_MESSAGES_IN_SKYTEL_MAILBOX
     * @uses self::VALUE_SPECIAL_EVENT_MODEM_ENCRYPTION_FAILURE
     * @uses self::VALUE_SPECIAL_EVENT_SERVICE_PLAN_ATTEMPTFAILURE
     * @uses self::VALUE_SPECIAL_EVENT_UNIT_COMMAND_MAX_REACHED
     * @uses self::VALUE_SPECIAL_EVENT_BLOCK_COUNT_EXCEEDED
     * @uses self::VALUE_SPECIAL_EVENT_NOT_RESPONDING
     * @uses self::VALUE_SPECIAL_EVENT_RADIO_OFF
     * @uses self::VALUE_SPECIAL_EVENT_RADIO_RESTORED
     * @uses self::VALUE_SPECIAL_EVENT_LOW_MODEM_SIGNAL_LEVEL
     * @uses self::VALUE_SPECIAL_EVENT_PANEL_POWER_FAILURE
     * @uses self::VALUE_SPECIAL_EVENT_PANEL_POWER_RESTORED
     * @uses self::VALUE_SPECIAL_EVENT_LOW_BATTERY
     * @uses self::VALUE_SPECIAL_EVENT_CAMERA_FAILED_STATE
     * @uses self::VALUE_SPECIAL_EVENT_CAMERA_CONNECTION_RESTORED
     * @uses self::VALUE_SPECIAL_EVENT_UPLOADS_OVER_QUOTA
     * @uses self::VALUE_SPECIAL_EVENT_NOT_RESPONDING_RESTORE
     * @uses self::VALUE_SPECIAL_EVENT_WATER_ALERT
     * @uses self::VALUE_SPECIAL_EVENT_DRY_CONTACT
     * @uses self::VALUE_SPECIAL_EVENT_OIL_GAUGE
     * @uses self::VALUE_SPECIAL_EVENT_PANEL_TAMPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CLOSED,
            self::VALUE_ALARM,
            self::VALUE_VALUE,
            self::VALUE_FIRE_ALARM,
            self::VALUE_LOW_BATTERY,
            self::VALUE_POWER_FAILURE,
            self::VALUE_MALFUNCTION,
            self::VALUE_TAMPER,
            self::VALUE_DISARMED,
            self::VALUE_ARMED_STAY,
            self::VALUE_ARMED_AWAY,
            self::VALUE_ARMING_FAILED,
            self::VALUE_DISARMING_FAILED,
            self::VALUE_BYPASSED,
            self::VALUE_PROGRAMMED,
            self::VALUE_OPENED,
            self::VALUE_POWER_RESTORED,
            self::VALUE_AUXILIARY_PANIC,
            self::VALUE_DURESS,
            self::VALUE_PHONE_LINE_FAILURE,
            self::VALUE_PANEL_NOT_RESPONDING,
            self::VALUE_TEMPERATURE_ALERT,
            self::VALUE_POLICE_PANIC,
            self::VALUE_CARBON_MONOXIDE,
            self::VALUE_FIRE_PANIC,
            self::VALUE_NO_ACTIVITY_ALARM,
            self::VALUE_FLOOD_EXTREME_TEMP_ALARM,
            self::VALUE_EXIT_FAULT,
            self::VALUE_RECENT_ARMING,
            self::VALUE_END_OF_TAMPERING,
            self::VALUE_PHONE_LINE_RESTORED,
            self::VALUE_END_OF_MALFUNCTION,
            self::VALUE_KEYPAD_TAMPER_ALARM,
            self::VALUE_TAMPER_ALARM,
            self::VALUE_WATER_ALARM,
            self::VALUE_END_OF_BYPASS,
            self::VALUE_BATTERY_OK,
            self::VALUE_MODULE_MALFUNCTION,
            self::VALUE_RADIO_OFF,
            self::VALUE_RADIO_RESTORED,
            self::VALUE_END_OF_MODULE_MALFUNCTION,
            self::VALUE_SILENT_ALARM_CLEAR,
            self::VALUE_GE_SPECIAL_EVENT,
            self::VALUE_INACTIVITY_FAULT,
            self::VALUE_INACTIVITY_RESTORAL,
            self::VALUE_DURESS_ALARM_CLEAR,
            self::VALUE_CLEAR_ACTIVE_ALARMS,
            self::VALUE_DISARMING_SUPERVISION_FAULT,
            self::VALUE_ARMING_SUPERVISION_FAULT,
            self::VALUE_AUTO_PHONE_TEST,
            self::VALUE_MANUAL_PHONE_TEST,
            self::VALUE_CS_FORWARDING_FAILURE,
            self::VALUE_PANEL_COMMUNICATION_FAILURE,
            self::VALUE_PANEL_COMMUNICATION_RESTORE,
            self::VALUE_NOT_RESPONDING_RESTORE,
            self::VALUE_SUCCESSFUL_WEBSITE_LOGIN,
            self::VALUE_FAILED_WEBSITE_LOGIN,
            self::VALUE_SENSOR_TEST_START,
            self::VALUE_SENSOR_TEST_END,
            self::VALUE_ENTRY_DELAY_TROUBLE,
            self::VALUE_POLICE_PANIC_PENDING_ALARM,
            self::VALUE_AUX_PANIC_PENDING_ALARM,
            self::VALUE_PENDING_ALARM,
            self::VALUE_SUSPECTED_ENTRY_DELAY_ALARM,
            self::VALUE_POLICE_PANIC_SUSPECTED_ALARM,
            self::VALUE_AUX_PANIC_SUSPECTED_ALARM,
            self::VALUE_SUSPECTED_ALARM,
            self::VALUE_RECEIVER_JAMMED,
            self::VALUE_SIREN_TAMPER,
            self::VALUE_SIREN_TAMPER_RESTORE,
            self::VALUE_TWO_TRIP_ERROR,
            self::VALUE_VIDEO_EVENT,
            self::VALUE_SENSOR_RESTORE,
            self::VALUE_SILENT_POLICE_PANIC,
            self::VALUE_ARMING_REMINDER,
            self::VALUE_SENSOR_LEFT_OPEN,
            self::VALUE_VIDEO_UPLOAD,
            self::VALUE_END_OF_RECEIVER_JAMMED,
            self::VALUE_CAMERA_ACCESS_TEST_OK,
            self::VALUE_CAMERA_ACCESS_TEST_FAIL,
            self::VALUE_CAMERA_FAILED_STATE,
            self::VALUE_CAMERA_RESTORED,
            self::VALUE_UPLOADS_OVER_50_PERCENT,
            self::VALUE_UPLOADS_OVER_90_PERCENT,
            self::VALUE_UPLOADS_OVER_QUOTA,
            self::VALUE_UPLOADS_QUOTA_CLEARED,
            self::VALUE_MEDICATION_ALERT,
            self::VALUE_LACK_OF_USAGE,
            self::VALUE_LATCHKEY_NOTIFICATION,
            self::VALUE_LATCHKEY_ARMING_REMINDER,
            self::VALUE_DOOR_UNLOCKED,
            self::VALUE_DOOR_LOCKED,
            self::VALUE_DOOR_ACCESSED,
            self::VALUE_BAD_LOCK_USER_CODE,
            self::VALUE_THERMOSTAT_SET_POINT_CHANGED,
            self::VALUE_THERMOSTAT_MODE_CHANGED,
            self::VALUE_TEMPERATURE_RESTORAL,
            self::VALUE_USER_TRIGGERED_VIDEO,
            self::VALUE_REMINDER,
            self::VALUE_IMAGE_SENSOR_UPLOAD,
            self::VALUE_OPENED_CLOSED,
            self::VALUE_SENSOR_LEFT_OPEN_RULE,
            self::VALUE_SENSOR_LEFT_CLOSED,
            self::VALUE_SENSOR_LEFT_OPEN_RESTORAL,
            self::VALUE_SENSOR_LEFT_CLOSED_RESTORAL,
            self::VALUE_THERMOSTAT_OFFSET,
            self::VALUE_IDPROTECTION_EVENT,
            self::VALUE_USAGE_GOAL_ALERT,
            self::VALUE_SILENT_ALARM,
            self::VALUE_TAMPER_PENDING_ALARM,
            self::VALUE_TAMPER_SUSPECTED_ALARM,
            self::VALUE_FIRE_PANIC_PENDING_ALARM,
            self::VALUE_FIRE_PANIC_SUSPECTED_ALARM,
            self::VALUE_ARMED_NIGHT,
            self::VALUE_SUMP_PUMP_ALERT_NORMAL_OPERATION,
            self::VALUE_SUMP_PUMP_ALERT_POSSIBLE_ISSUE,
            self::VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_OFF,
            self::VALUE_SUMP_PUMP_ALERT_CRITICAL_ISSUE_MALFUNCTION,
            self::VALUE_THERMOSTAT_FAN_MODE_CHANGED,
            self::VALUE_THERMOSTAT_SENSOR_LEFT_OPEN_OFFSET,
            self::VALUE_COMMERCIAL_EARLY_OPEN,
            self::VALUE_COMMERCIAL_LATE_OPEN,
            self::VALUE_COMMERCIAL_OPEN_ON_TIME,
            self::VALUE_COMMERCIAL_EARLY_CLOSE,
            self::VALUE_COMMERCIAL_LATE_CLOSE,
            self::VALUE_COMMERCIAL_CLOSED_ON_TIME,
            self::VALUE_IMAGE_UPLOADS_OVER_QUOTA,
            self::VALUE_SMS_OVER_QUOTA,
            self::VALUE_DEVICE_FAILED_TO_SECURE,
            self::VALUE_DISABLED,
            self::VALUE_END_OF_DISABLED,
            self::VALUE_SENT_EMAIL,
            self::VALUE_OK,
            self::VALUE_ISSUE,
            self::VALUE_DOORBELL_BUTTON_PRESS,
            self::VALUE_LOW_FUEL,
            self::VALUE_FUEL_OK,
            self::VALUE_ACCESS_CARD_SCANNED,
            self::VALUE_EXIT_BUTTON_PRESSED,
            self::VALUE_CAR_LOW_BATTERY,
            self::VALUE_CAR_BATTERY_OK,
            self::VALUE_CAR_CONNECTOR_NOT_RESPONDING,
            self::VALUE_CAR_CONNECTOR_COMMUNICATION_RESTORED,
            self::VALUE_CAR_DIAGNOSTIC_ISSUE_REPORTED,
            self::VALUE_CAR_DIAGNOSTIC_ISSUE_CLEARED,
            self::VALUE_CAR_UNEXPECTED_MOVEMENT_ALARM,
            self::VALUE_CAR_HIGH_SPEED_ALERT,
            self::VALUE_CAR_HARD_ACCELERATION_ALERT,
            self::VALUE_CAR_HARD_BRAKE_ALERT,
            self::VALUE_WATER_LEAK_ALERT,
            self::VALUE_EXTENDED_WATER_USAGE_ALERT,
            self::VALUE_WATER_LEAK_OR_EXTENDED_WATER_USAGE_RESTORAL,
            self::VALUE_CELL_DOOR_TAMPER,
            self::VALUE_END_OF_CELL_DOOR_TAMPER,
            self::VALUE_RECEIVER_JAMMED_ALARM,
            self::VALUE_VIEWED_BY_CENTRAL_STATION,
            self::VALUE_OSNAPP_ALARM_UPDATED,
            self::VALUE_OSNAPP_FORWARD_ALARM_TO_CS,
            self::VALUE_OSNAPP_LOCATION_REPORT,
            self::VALUE_OSNAPP_FORWARD_LOCATION_TO_CS,
            self::VALUE_BUTTON_PRESSED,
            self::VALUE_OSNAPP_NOTIFICATION_SENT,
            self::VALUE_DOORBELL_CALL_REQUEST,
            self::VALUE_CAR_UNEXPECTED_MOVEMENT_LOCATION_ALARM,
            self::VALUE_ENDOF_CAR_UNEXPECTED_MOVEMENT_ALARM,
            self::VALUE_ETHERNET_UNPLUGGED_EVENT,
            self::VALUE_ETHERNET_PLUGGED_IN_EVENT,
            self::VALUE_KEYPAD_LOCKED_OUT_EVENT,
            self::VALUE_SILENT_POLICE_PANIC_PENDING_ALARM,
            self::VALUE_SILENT_POLICE_PANIC_SUSPECTED_ALARM,
            self::VALUE_CAR_MONITOR_PLUGGED_IN,
            self::VALUE_SYSTEM_DATE_TIME_CHANGED,
            self::VALUE_COMMERCIAL_CLOSED_UNEXPECTEDLY,
            self::VALUE_CONTINUOUS_CLOUD_RECEIVER_STARTED,
            self::VALUE_CONTINUOUS_CLOUD_RECEIVER_STOPPED,
            self::VALUE_DOOR_FAILED_ACCESS,
            self::VALUE_DOOR_FORCED_OPEN,
            self::VALUE_DOOR_BUZZED_FROM_WEBSITE,
            self::VALUE_SITE_SPECIFIC_DATA_ALTERED,
            self::VALUE_DOOR_HELD_OPEN,
            self::VALUE_UNKNOWN_CARD_FORMAT_READ,
            self::VALUE_QUICK_EXIT,
            self::VALUE_DOOR_BUZZ_COMMAND_SENT,
            self::VALUE_UNLOCK_COMMAND_SENT,
            self::VALUE_LOCK_COMMAND_SENT,
            self::VALUE_PGM_2_FIRE_TROUBLE,
            self::VALUE_END_OF_PGM_2_FIRE_TROUBLE,
            self::VALUE_OVLBASIC,
            self::VALUE_OVLADVANCED,
            self::VALUE_SPECIAL_EVENT_MODEM_POWER_UP,
            self::VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_ERROR,
            self::VALUE_SPECIAL_EVENT_MODEM_PANEL_COMM_OK,
            self::VALUE_SPECIAL_EVENT_CODE_LOCK_SETTING_IS_ON,
            self::VALUE_SPECIAL_EVENT_MALFUNCTION,
            self::VALUE_SPECIAL_EVENT_TAMPER,
            self::VALUE_SPECIAL_EVENT_NO_MESSAGES_FROM_SKYTEL_IN_LAST_50_CYCLES,
            self::VALUE_SPECIAL_EVENT_EXCESSIVE_OLD_MESSAGES_IN_SKYTEL_MAILBOX,
            self::VALUE_SPECIAL_EVENT_MODEM_ENCRYPTION_FAILURE,
            self::VALUE_SPECIAL_EVENT_SERVICE_PLAN_ATTEMPTFAILURE,
            self::VALUE_SPECIAL_EVENT_UNIT_COMMAND_MAX_REACHED,
            self::VALUE_SPECIAL_EVENT_BLOCK_COUNT_EXCEEDED,
            self::VALUE_SPECIAL_EVENT_NOT_RESPONDING,
            self::VALUE_SPECIAL_EVENT_RADIO_OFF,
            self::VALUE_SPECIAL_EVENT_RADIO_RESTORED,
            self::VALUE_SPECIAL_EVENT_LOW_MODEM_SIGNAL_LEVEL,
            self::VALUE_SPECIAL_EVENT_PANEL_POWER_FAILURE,
            self::VALUE_SPECIAL_EVENT_PANEL_POWER_RESTORED,
            self::VALUE_SPECIAL_EVENT_LOW_BATTERY,
            self::VALUE_SPECIAL_EVENT_CAMERA_FAILED_STATE,
            self::VALUE_SPECIAL_EVENT_CAMERA_CONNECTION_RESTORED,
            self::VALUE_SPECIAL_EVENT_UPLOADS_OVER_QUOTA,
            self::VALUE_SPECIAL_EVENT_NOT_RESPONDING_RESTORE,
            self::VALUE_SPECIAL_EVENT_WATER_ALERT,
            self::VALUE_SPECIAL_EVENT_DRY_CONTACT,
            self::VALUE_SPECIAL_EVENT_OIL_GAUGE,
            self::VALUE_SPECIAL_EVENT_PANEL_TAMPER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
