<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateNotifications StructType
 * @subpackage Structs
 */
class UpdateNotifications extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public $subscriptions;
    /**
     * Constructor method for UpdateNotifications
     * @uses UpdateNotifications::setCustomerId()
     * @uses UpdateNotifications::setSubscriptions()
     * @param int $customerId
     * @param \CustomerManagement\ArrayType\ArrayOfNotificationSubscription $subscriptions
     */
    public function __construct($customerId = null, \CustomerManagement\ArrayType\ArrayOfNotificationSubscription $subscriptions = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateNotifications
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get subscriptions value
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * Set subscriptions value
     * @param \CustomerManagement\ArrayType\ArrayOfNotificationSubscription $subscriptions
     * @return \CustomerManagement\StructType\UpdateNotifications
     */
    public function setSubscriptions(\CustomerManagement\ArrayType\ArrayOfNotificationSubscription $subscriptions = null)
    {
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateNotifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
