<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelSettingCriteria StructType
 * @subpackage Structs
 */
class PanelSettingCriteria extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The PanelSettingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelSettingId;
    /**
     * The ExcludeSearchedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludeSearchedValue;
    /**
     * The SearchedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchedValue;
    /**
     * Constructor method for PanelSettingCriteria
     * @uses PanelSettingCriteria::setDeviceId()
     * @uses PanelSettingCriteria::setPanelSettingId()
     * @uses PanelSettingCriteria::setExcludeSearchedValue()
     * @uses PanelSettingCriteria::setSearchedValue()
     * @param int $deviceId
     * @param int $panelSettingId
     * @param bool $excludeSearchedValue
     * @param string $searchedValue
     */
    public function __construct($deviceId = null, $panelSettingId = null, $excludeSearchedValue = null, $searchedValue = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setPanelSettingId($panelSettingId)
            ->setExcludeSearchedValue($excludeSearchedValue)
            ->setSearchedValue($searchedValue);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\PanelSettingCriteria
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get PanelSettingId value
     * @return int
     */
    public function getPanelSettingId()
    {
        return $this->PanelSettingId;
    }
    /**
     * Set PanelSettingId value
     * @param int $panelSettingId
     * @return \CustomerManagement\StructType\PanelSettingCriteria
     */
    public function setPanelSettingId($panelSettingId = null)
    {
        // validation for constraint: int
        if (!is_null($panelSettingId) && !(is_int($panelSettingId) || ctype_digit($panelSettingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelSettingId, true), gettype($panelSettingId)), __LINE__);
        }
        $this->PanelSettingId = $panelSettingId;
        return $this;
    }
    /**
     * Get ExcludeSearchedValue value
     * @return bool
     */
    public function getExcludeSearchedValue()
    {
        return $this->ExcludeSearchedValue;
    }
    /**
     * Set ExcludeSearchedValue value
     * @param bool $excludeSearchedValue
     * @return \CustomerManagement\StructType\PanelSettingCriteria
     */
    public function setExcludeSearchedValue($excludeSearchedValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeSearchedValue) && !is_bool($excludeSearchedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeSearchedValue, true), gettype($excludeSearchedValue)), __LINE__);
        }
        $this->ExcludeSearchedValue = $excludeSearchedValue;
        return $this;
    }
    /**
     * Get SearchedValue value
     * @return string|null
     */
    public function getSearchedValue()
    {
        return $this->SearchedValue;
    }
    /**
     * Set SearchedValue value
     * @param string $searchedValue
     * @return \CustomerManagement\StructType\PanelSettingCriteria
     */
    public function setSearchedValue($searchedValue = null)
    {
        // validation for constraint: string
        if (!is_null($searchedValue) && !is_string($searchedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchedValue, true), gettype($searchedValue)), __LINE__);
        }
        $this->SearchedValue = $searchedValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\PanelSettingCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
