<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEnterpriseRolesInput StructType
 * @subpackage Structs
 */
class UpdateEnterpriseRolesInput extends AbstractStructBase
{
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The LoginIdToUpdate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LoginIdToUpdate;
    /**
     * The AuthenticationProviderLoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationProviderLoginName;
    /**
     * The Roles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $Roles;
    /**
     * Constructor method for UpdateEnterpriseRolesInput
     * @uses UpdateEnterpriseRolesInput::setGroupId()
     * @uses UpdateEnterpriseRolesInput::setLoginIdToUpdate()
     * @uses UpdateEnterpriseRolesInput::setAuthenticationProviderLoginName()
     * @uses UpdateEnterpriseRolesInput::setRoles()
     * @param int $groupId
     * @param int $loginIdToUpdate
     * @param string $authenticationProviderLoginName
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     */
    public function __construct($groupId = null, $loginIdToUpdate = null, $authenticationProviderLoginName = null, \CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this
            ->setGroupId($groupId)
            ->setLoginIdToUpdate($loginIdToUpdate)
            ->setAuthenticationProviderLoginName($authenticationProviderLoginName)
            ->setRoles($roles);
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesInput
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get LoginIdToUpdate value
     * @return int
     */
    public function getLoginIdToUpdate()
    {
        return $this->LoginIdToUpdate;
    }
    /**
     * Set LoginIdToUpdate value
     * @param int $loginIdToUpdate
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesInput
     */
    public function setLoginIdToUpdate($loginIdToUpdate = null)
    {
        // validation for constraint: int
        if (!is_null($loginIdToUpdate) && !(is_int($loginIdToUpdate) || ctype_digit($loginIdToUpdate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginIdToUpdate, true), gettype($loginIdToUpdate)), __LINE__);
        }
        $this->LoginIdToUpdate = $loginIdToUpdate;
        return $this;
    }
    /**
     * Get AuthenticationProviderLoginName value
     * @return string|null
     */
    public function getAuthenticationProviderLoginName()
    {
        return $this->AuthenticationProviderLoginName;
    }
    /**
     * Set AuthenticationProviderLoginName value
     * @param string $authenticationProviderLoginName
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesInput
     */
    public function setAuthenticationProviderLoginName($authenticationProviderLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationProviderLoginName) && !is_string($authenticationProviderLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationProviderLoginName, true), gettype($authenticationProviderLoginName)), __LINE__);
        }
        $this->AuthenticationProviderLoginName = $authenticationProviderLoginName;
        return $this;
    }
    /**
     * Get Roles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesInput
     */
    public function setRoles(\CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
