<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoginInfoOutput ArrayType
 * @subpackage Arrays
 */
class ArrayOfLoginInfoOutput extends AbstractStructArrayBase
{
    /**
     * The LoginInfoOutput
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\LoginInfoOutput[]
     */
    public $LoginInfoOutput;
    /**
     * Constructor method for ArrayOfLoginInfoOutput
     * @uses ArrayOfLoginInfoOutput::setLoginInfoOutput()
     * @param \CustomerManagement\StructType\LoginInfoOutput[] $loginInfoOutput
     */
    public function __construct(array $loginInfoOutput = array())
    {
        $this
            ->setLoginInfoOutput($loginInfoOutput);
    }
    /**
     * Get LoginInfoOutput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\LoginInfoOutput[]|null
     */
    public function getLoginInfoOutput()
    {
        return isset($this->LoginInfoOutput) ? $this->LoginInfoOutput : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLoginInfoOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoginInfoOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoginInfoOutputForArrayConstraintsFromSetLoginInfoOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLoginInfoOutputLoginInfoOutputItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoginInfoOutputLoginInfoOutputItem instanceof \CustomerManagement\StructType\LoginInfoOutput) {
                $invalidValues[] = is_object($arrayOfLoginInfoOutputLoginInfoOutputItem) ? get_class($arrayOfLoginInfoOutputLoginInfoOutputItem) : sprintf('%s(%s)', gettype($arrayOfLoginInfoOutputLoginInfoOutputItem), var_export($arrayOfLoginInfoOutputLoginInfoOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoginInfoOutput property can only contain items of type \CustomerManagement\StructType\LoginInfoOutput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoginInfoOutput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\LoginInfoOutput[] $loginInfoOutput
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfoOutput
     */
    public function setLoginInfoOutput(array $loginInfoOutput = array())
    {
        // validation for constraint: array
        if ('' !== ($loginInfoOutputArrayErrorMessage = self::validateLoginInfoOutputForArrayConstraintsFromSetLoginInfoOutput($loginInfoOutput))) {
            throw new \InvalidArgumentException($loginInfoOutputArrayErrorMessage, __LINE__);
        }
        if (is_null($loginInfoOutput) || (is_array($loginInfoOutput) && empty($loginInfoOutput))) {
            unset($this->LoginInfoOutput);
        } else {
            $this->LoginInfoOutput = $loginInfoOutput;
        }
        return $this;
    }
    /**
     * Add item to LoginInfoOutput value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\LoginInfoOutput $item
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfoOutput
     */
    public function addToLoginInfoOutput(\CustomerManagement\StructType\LoginInfoOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\LoginInfoOutput) {
            throw new \InvalidArgumentException(sprintf('The LoginInfoOutput property can only contain items of type \CustomerManagement\StructType\LoginInfoOutput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoginInfoOutput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\LoginInfoOutput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\LoginInfoOutput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\LoginInfoOutput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\LoginInfoOutput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\LoginInfoOutput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LoginInfoOutput
     */
    public function getAttributeName()
    {
        return 'LoginInfoOutput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfoOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
