<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomDevicesInput StructType
 * @subpackage Structs
 */
class UpdateCustomDevicesInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Devices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPanelDevice
     */
    public $Devices;
    /**
     * The TypesToClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum
     */
    public $TypesToClear;
    /**
     * Constructor method for UpdateCustomDevicesInput
     * @uses UpdateCustomDevicesInput::setCustomerId()
     * @uses UpdateCustomDevicesInput::setDevices()
     * @uses UpdateCustomDevicesInput::setTypesToClear()
     * @param int $customerId
     * @param \CustomerManagement\ArrayType\ArrayOfPanelDevice $devices
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum $typesToClear
     */
    public function __construct($customerId = null, \CustomerManagement\ArrayType\ArrayOfPanelDevice $devices = null, \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum $typesToClear = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDevices($devices)
            ->setTypesToClear($typesToClear);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomDevicesInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Devices value
     * @return \CustomerManagement\ArrayType\ArrayOfPanelDevice|null
     */
    public function getDevices()
    {
        return $this->Devices;
    }
    /**
     * Set Devices value
     * @param \CustomerManagement\ArrayType\ArrayOfPanelDevice $devices
     * @return \CustomerManagement\StructType\UpdateCustomDevicesInput
     */
    public function setDevices(\CustomerManagement\ArrayType\ArrayOfPanelDevice $devices = null)
    {
        $this->Devices = $devices;
        return $this;
    }
    /**
     * Get TypesToClear value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum|null
     */
    public function getTypesToClear()
    {
        return $this->TypesToClear;
    }
    /**
     * Set TypesToClear value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum $typesToClear
     * @return \CustomerManagement\StructType\UpdateCustomDevicesInput
     */
    public function setTypesToClear(\CustomerManagement\ArrayType\ArrayOfDeviceTypeEnum $typesToClear = null)
    {
        $this->TypesToClear = $typesToClear;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomDevicesInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
