<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceStatusEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeviceStatusEnum extends AbstractStructArrayBase
{
    /**
     * The DeviceStatusEnum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DeviceStatusEnum;
    /**
     * Constructor method for ArrayOfDeviceStatusEnum
     * @uses ArrayOfDeviceStatusEnum::setDeviceStatusEnum()
     * @param string[] $deviceStatusEnum
     */
    public function __construct(array $deviceStatusEnum = array())
    {
        $this
            ->setDeviceStatusEnum($deviceStatusEnum);
    }
    /**
     * Get DeviceStatusEnum value
     * @return string[]|null
     */
    public function getDeviceStatusEnum()
    {
        return $this->DeviceStatusEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceStatusEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceStatusEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceStatusEnumForArrayConstraintsFromSetDeviceStatusEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeviceStatusEnumDeviceStatusEnumItem) {
            // validation for constraint: enumeration
            if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($arrayOfDeviceStatusEnumDeviceStatusEnumItem)) {
                $invalidValues[] = is_object($arrayOfDeviceStatusEnumDeviceStatusEnumItem) ? get_class($arrayOfDeviceStatusEnumDeviceStatusEnumItem) : sprintf('%s(%s)', gettype($arrayOfDeviceStatusEnumDeviceStatusEnumItem), var_export($arrayOfDeviceStatusEnumDeviceStatusEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceStatusEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceStatusEnum value
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $deviceStatusEnum
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function setDeviceStatusEnum(array $deviceStatusEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceStatusEnumArrayErrorMessage = self::validateDeviceStatusEnumForArrayConstraintsFromSetDeviceStatusEnum($deviceStatusEnum))) {
            throw new \InvalidArgumentException($deviceStatusEnumArrayErrorMessage, __LINE__);
        }
        $this->DeviceStatusEnum = $deviceStatusEnum;
        return $this;
    }
    /**
     * Add item to DeviceStatusEnum value
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function addToDeviceStatusEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceStatusEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues())), __LINE__);
        }
        $this->DeviceStatusEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceStatusEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceStatusEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\DeviceStatusEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceStatusEnum
     */
    public function getAttributeName()
    {
        return 'DeviceStatusEnum';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceStatusEnum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
