<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElectricityProviderInfo StructType
 * @subpackage Structs
 */
class ElectricityProviderInfo extends AbstractStructBase
{
    /**
     * The LseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LseId;
    /**
     * The LseName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LseName;
    /**
     * Constructor method for ElectricityProviderInfo
     * @uses ElectricityProviderInfo::setLseId()
     * @uses ElectricityProviderInfo::setLseName()
     * @param int $lseId
     * @param string $lseName
     */
    public function __construct($lseId = null, $lseName = null)
    {
        $this
            ->setLseId($lseId)
            ->setLseName($lseName);
    }
    /**
     * Get LseId value
     * @return int
     */
    public function getLseId()
    {
        return $this->LseId;
    }
    /**
     * Set LseId value
     * @param int $lseId
     * @return \CustomerManagement\StructType\ElectricityProviderInfo
     */
    public function setLseId($lseId = null)
    {
        // validation for constraint: int
        if (!is_null($lseId) && !(is_int($lseId) || ctype_digit($lseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lseId, true), gettype($lseId)), __LINE__);
        }
        $this->LseId = $lseId;
        return $this;
    }
    /**
     * Get LseName value
     * @return string|null
     */
    public function getLseName()
    {
        return $this->LseName;
    }
    /**
     * Set LseName value
     * @param string $lseName
     * @return \CustomerManagement\StructType\ElectricityProviderInfo
     */
    public function setLseName($lseName = null)
    {
        // validation for constraint: string
        if (!is_null($lseName) && !is_string($lseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lseName, true), gettype($lseName)), __LINE__);
        }
        $this->LseName = $lseName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ElectricityProviderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
