<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageSensorInfo StructType
 * @subpackage Structs
 */
class ImageSensorInfo extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The RulesConfirmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RulesConfirmed;
    /**
     * The CapturesLast60Days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CapturesLast60Days;
    /**
     * The UploadsLast60Days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UploadsLast60Days;
    /**
     * The UploadsThisMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UploadsThisMonth;
    /**
     * The SignalStrengthPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SignalStrengthPercent;
    /**
     * The CurrentBatteryVoltage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentBatteryVoltage;
    /**
     * The BatteryVoltageTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BatteryVoltageTime;
    /**
     * The HasAlarmNotifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasAlarmNotifications;
    /**
     * The HasManualUploadNotifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasManualUploadNotifications;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The PartitionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartitionId;
    /**
     * The LEDModeEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LEDModeEnabled;
    /**
     * The AutoZoomSupported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoZoomSupported;
    /**
     * The AutoZoomEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoZoomEnabled;
    /**
     * The ExtendedRangeOnDaughterboardSupported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExtendedRangeOnDaughterboardSupported;
    /**
     * The ExtendedRangeOnDaughterboardEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExtendedRangeOnDaughterboardEnabled;
    /**
     * The MAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MAC;
    /**
     * The FirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * Constructor method for ImageSensorInfo
     * @uses ImageSensorInfo::setCustomerId()
     * @uses ImageSensorInfo::setDeviceId()
     * @uses ImageSensorInfo::setRulesConfirmed()
     * @uses ImageSensorInfo::setCapturesLast60Days()
     * @uses ImageSensorInfo::setUploadsLast60Days()
     * @uses ImageSensorInfo::setUploadsThisMonth()
     * @uses ImageSensorInfo::setSignalStrengthPercent()
     * @uses ImageSensorInfo::setCurrentBatteryVoltage()
     * @uses ImageSensorInfo::setBatteryVoltageTime()
     * @uses ImageSensorInfo::setHasAlarmNotifications()
     * @uses ImageSensorInfo::setHasManualUploadNotifications()
     * @uses ImageSensorInfo::setGroupId()
     * @uses ImageSensorInfo::setPartitionId()
     * @uses ImageSensorInfo::setLEDModeEnabled()
     * @uses ImageSensorInfo::setAutoZoomSupported()
     * @uses ImageSensorInfo::setAutoZoomEnabled()
     * @uses ImageSensorInfo::setExtendedRangeOnDaughterboardSupported()
     * @uses ImageSensorInfo::setExtendedRangeOnDaughterboardEnabled()
     * @uses ImageSensorInfo::setMAC()
     * @uses ImageSensorInfo::setFirmwareVersion()
     * @param int $customerId
     * @param int $deviceId
     * @param bool $rulesConfirmed
     * @param int $capturesLast60Days
     * @param int $uploadsLast60Days
     * @param int $uploadsThisMonth
     * @param int $signalStrengthPercent
     * @param float $currentBatteryVoltage
     * @param string $batteryVoltageTime
     * @param bool $hasAlarmNotifications
     * @param bool $hasManualUploadNotifications
     * @param int $groupId
     * @param int $partitionId
     * @param bool $lEDModeEnabled
     * @param bool $autoZoomSupported
     * @param bool $autoZoomEnabled
     * @param bool $extendedRangeOnDaughterboardSupported
     * @param bool $extendedRangeOnDaughterboardEnabled
     * @param string $mAC
     * @param string $firmwareVersion
     */
    public function __construct($customerId = null, $deviceId = null, $rulesConfirmed = null, $capturesLast60Days = null, $uploadsLast60Days = null, $uploadsThisMonth = null, $signalStrengthPercent = null, $currentBatteryVoltage = null, $batteryVoltageTime = null, $hasAlarmNotifications = null, $hasManualUploadNotifications = null, $groupId = null, $partitionId = null, $lEDModeEnabled = null, $autoZoomSupported = null, $autoZoomEnabled = null, $extendedRangeOnDaughterboardSupported = null, $extendedRangeOnDaughterboardEnabled = null, $mAC = null, $firmwareVersion = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setRulesConfirmed($rulesConfirmed)
            ->setCapturesLast60Days($capturesLast60Days)
            ->setUploadsLast60Days($uploadsLast60Days)
            ->setUploadsThisMonth($uploadsThisMonth)
            ->setSignalStrengthPercent($signalStrengthPercent)
            ->setCurrentBatteryVoltage($currentBatteryVoltage)
            ->setBatteryVoltageTime($batteryVoltageTime)
            ->setHasAlarmNotifications($hasAlarmNotifications)
            ->setHasManualUploadNotifications($hasManualUploadNotifications)
            ->setGroupId($groupId)
            ->setPartitionId($partitionId)
            ->setLEDModeEnabled($lEDModeEnabled)
            ->setAutoZoomSupported($autoZoomSupported)
            ->setAutoZoomEnabled($autoZoomEnabled)
            ->setExtendedRangeOnDaughterboardSupported($extendedRangeOnDaughterboardSupported)
            ->setExtendedRangeOnDaughterboardEnabled($extendedRangeOnDaughterboardEnabled)
            ->setMAC($mAC)
            ->setFirmwareVersion($firmwareVersion);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !is_numeric($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get RulesConfirmed value
     * @return bool
     */
    public function getRulesConfirmed()
    {
        return $this->RulesConfirmed;
    }
    /**
     * Set RulesConfirmed value
     * @param bool $rulesConfirmed
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setRulesConfirmed($rulesConfirmed = null)
    {
        $this->RulesConfirmed = $rulesConfirmed;
        return $this;
    }
    /**
     * Get CapturesLast60Days value
     * @return int
     */
    public function getCapturesLast60Days()
    {
        return $this->CapturesLast60Days;
    }
    /**
     * Set CapturesLast60Days value
     * @param int $capturesLast60Days
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setCapturesLast60Days($capturesLast60Days = null)
    {
        // validation for constraint: int
        if (!is_null($capturesLast60Days) && !is_numeric($capturesLast60Days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capturesLast60Days)), __LINE__);
        }
        $this->CapturesLast60Days = $capturesLast60Days;
        return $this;
    }
    /**
     * Get UploadsLast60Days value
     * @return int
     */
    public function getUploadsLast60Days()
    {
        return $this->UploadsLast60Days;
    }
    /**
     * Set UploadsLast60Days value
     * @param int $uploadsLast60Days
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setUploadsLast60Days($uploadsLast60Days = null)
    {
        // validation for constraint: int
        if (!is_null($uploadsLast60Days) && !is_numeric($uploadsLast60Days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uploadsLast60Days)), __LINE__);
        }
        $this->UploadsLast60Days = $uploadsLast60Days;
        return $this;
    }
    /**
     * Get UploadsThisMonth value
     * @return int
     */
    public function getUploadsThisMonth()
    {
        return $this->UploadsThisMonth;
    }
    /**
     * Set UploadsThisMonth value
     * @param int $uploadsThisMonth
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setUploadsThisMonth($uploadsThisMonth = null)
    {
        // validation for constraint: int
        if (!is_null($uploadsThisMonth) && !is_numeric($uploadsThisMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uploadsThisMonth)), __LINE__);
        }
        $this->UploadsThisMonth = $uploadsThisMonth;
        return $this;
    }
    /**
     * Get SignalStrengthPercent value
     * @return int
     */
    public function getSignalStrengthPercent()
    {
        return $this->SignalStrengthPercent;
    }
    /**
     * Set SignalStrengthPercent value
     * @param int $signalStrengthPercent
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setSignalStrengthPercent($signalStrengthPercent = null)
    {
        // validation for constraint: int
        if (!is_null($signalStrengthPercent) && !is_numeric($signalStrengthPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($signalStrengthPercent)), __LINE__);
        }
        $this->SignalStrengthPercent = $signalStrengthPercent;
        return $this;
    }
    /**
     * Get CurrentBatteryVoltage value
     * @return float
     */
    public function getCurrentBatteryVoltage()
    {
        return $this->CurrentBatteryVoltage;
    }
    /**
     * Set CurrentBatteryVoltage value
     * @param float $currentBatteryVoltage
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setCurrentBatteryVoltage($currentBatteryVoltage = null)
    {
        $this->CurrentBatteryVoltage = $currentBatteryVoltage;
        return $this;
    }
    /**
     * Get BatteryVoltageTime value
     * @return string
     */
    public function getBatteryVoltageTime()
    {
        return $this->BatteryVoltageTime;
    }
    /**
     * Set BatteryVoltageTime value
     * @param string $batteryVoltageTime
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setBatteryVoltageTime($batteryVoltageTime = null)
    {
        // validation for constraint: string
        if (!is_null($batteryVoltageTime) && !is_string($batteryVoltageTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batteryVoltageTime)), __LINE__);
        }
        $this->BatteryVoltageTime = $batteryVoltageTime;
        return $this;
    }
    /**
     * Get HasAlarmNotifications value
     * @return bool
     */
    public function getHasAlarmNotifications()
    {
        return $this->HasAlarmNotifications;
    }
    /**
     * Set HasAlarmNotifications value
     * @param bool $hasAlarmNotifications
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setHasAlarmNotifications($hasAlarmNotifications = null)
    {
        $this->HasAlarmNotifications = $hasAlarmNotifications;
        return $this;
    }
    /**
     * Get HasManualUploadNotifications value
     * @return bool
     */
    public function getHasManualUploadNotifications()
    {
        return $this->HasManualUploadNotifications;
    }
    /**
     * Set HasManualUploadNotifications value
     * @param bool $hasManualUploadNotifications
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setHasManualUploadNotifications($hasManualUploadNotifications = null)
    {
        $this->HasManualUploadNotifications = $hasManualUploadNotifications;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get PartitionId value
     * @return int
     */
    public function getPartitionId()
    {
        return $this->PartitionId;
    }
    /**
     * Set PartitionId value
     * @param int $partitionId
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setPartitionId($partitionId = null)
    {
        // validation for constraint: int
        if (!is_null($partitionId) && !is_numeric($partitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partitionId)), __LINE__);
        }
        $this->PartitionId = $partitionId;
        return $this;
    }
    /**
     * Get LEDModeEnabled value
     * @return bool
     */
    public function getLEDModeEnabled()
    {
        return $this->LEDModeEnabled;
    }
    /**
     * Set LEDModeEnabled value
     * @param bool $lEDModeEnabled
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setLEDModeEnabled($lEDModeEnabled = null)
    {
        $this->LEDModeEnabled = $lEDModeEnabled;
        return $this;
    }
    /**
     * Get AutoZoomSupported value
     * @return bool
     */
    public function getAutoZoomSupported()
    {
        return $this->AutoZoomSupported;
    }
    /**
     * Set AutoZoomSupported value
     * @param bool $autoZoomSupported
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setAutoZoomSupported($autoZoomSupported = null)
    {
        $this->AutoZoomSupported = $autoZoomSupported;
        return $this;
    }
    /**
     * Get AutoZoomEnabled value
     * @return bool
     */
    public function getAutoZoomEnabled()
    {
        return $this->AutoZoomEnabled;
    }
    /**
     * Set AutoZoomEnabled value
     * @param bool $autoZoomEnabled
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setAutoZoomEnabled($autoZoomEnabled = null)
    {
        $this->AutoZoomEnabled = $autoZoomEnabled;
        return $this;
    }
    /**
     * Get ExtendedRangeOnDaughterboardSupported value
     * @return bool
     */
    public function getExtendedRangeOnDaughterboardSupported()
    {
        return $this->ExtendedRangeOnDaughterboardSupported;
    }
    /**
     * Set ExtendedRangeOnDaughterboardSupported value
     * @param bool $extendedRangeOnDaughterboardSupported
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setExtendedRangeOnDaughterboardSupported($extendedRangeOnDaughterboardSupported = null)
    {
        $this->ExtendedRangeOnDaughterboardSupported = $extendedRangeOnDaughterboardSupported;
        return $this;
    }
    /**
     * Get ExtendedRangeOnDaughterboardEnabled value
     * @return bool
     */
    public function getExtendedRangeOnDaughterboardEnabled()
    {
        return $this->ExtendedRangeOnDaughterboardEnabled;
    }
    /**
     * Set ExtendedRangeOnDaughterboardEnabled value
     * @param bool $extendedRangeOnDaughterboardEnabled
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setExtendedRangeOnDaughterboardEnabled($extendedRangeOnDaughterboardEnabled = null)
    {
        $this->ExtendedRangeOnDaughterboardEnabled = $extendedRangeOnDaughterboardEnabled;
        return $this;
    }
    /**
     * Get MAC value
     * @return string|null
     */
    public function getMAC()
    {
        return $this->MAC;
    }
    /**
     * Set MAC value
     * @param string $mAC
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setMAC($mAC = null)
    {
        // validation for constraint: string
        if (!is_null($mAC) && !is_string($mAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mAC)), __LINE__);
        }
        $this->MAC = $mAC;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ImageSensorInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
