<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableWifiNetworksOutput StructType
 * @subpackage Structs
 */
class GetAvailableWifiNetworksOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The WiFiNetworks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo
     */
    public $WiFiNetworks;
    /**
     * Constructor method for GetAvailableWifiNetworksOutput
     * @uses GetAvailableWifiNetworksOutput::setSuccess()
     * @uses GetAvailableWifiNetworksOutput::setErrorMessage()
     * @uses GetAvailableWifiNetworksOutput::setWiFiNetworks()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setWiFiNetworks($wiFiNetworks);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get WiFiNetworks value
     * @return \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo|null
     */
    public function getWiFiNetworks()
    {
        return $this->WiFiNetworks;
    }
    /**
     * Set WiFiNetworks value
     * @param \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setWiFiNetworks(\CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks = null)
    {
        $this->WiFiNetworks = $wiFiNetworks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
