<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfElectricityProviderInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfElectricityProviderInfo extends AbstractStructArrayBase
{
    /**
     * The ElectricityProviderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\ElectricityProviderInfo[]
     */
    public $ElectricityProviderInfo;
    /**
     * Constructor method for ArrayOfElectricityProviderInfo
     * @uses ArrayOfElectricityProviderInfo::setElectricityProviderInfo()
     * @param \CustomerManagement\StructType\ElectricityProviderInfo[] $electricityProviderInfo
     */
    public function __construct(array $electricityProviderInfo = array())
    {
        $this
            ->setElectricityProviderInfo($electricityProviderInfo);
    }
    /**
     * Get ElectricityProviderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\ElectricityProviderInfo[]|null
     */
    public function getElectricityProviderInfo()
    {
        return isset($this->ElectricityProviderInfo) ? $this->ElectricityProviderInfo : null;
    }
    /**
     * Set ElectricityProviderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ElectricityProviderInfo[] $electricityProviderInfo
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public function setElectricityProviderInfo(array $electricityProviderInfo = array())
    {
        foreach ($electricityProviderInfo as $arrayOfElectricityProviderInfoElectricityProviderInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfElectricityProviderInfoElectricityProviderInfoItem instanceof \CustomerManagement\StructType\ElectricityProviderInfo) {
                throw new \InvalidArgumentException(sprintf('The ElectricityProviderInfo property can only contain items of \CustomerManagement\StructType\ElectricityProviderInfo, "%s" given', is_object($arrayOfElectricityProviderInfoElectricityProviderInfoItem) ? get_class($arrayOfElectricityProviderInfoElectricityProviderInfoItem) : gettype($arrayOfElectricityProviderInfoElectricityProviderInfoItem)), __LINE__);
            }
        }
        if (is_null($electricityProviderInfo) || (is_array($electricityProviderInfo) && empty($electricityProviderInfo))) {
            unset($this->ElectricityProviderInfo);
        } else {
            $this->ElectricityProviderInfo = $electricityProviderInfo;
        }
        return $this;
    }
    /**
     * Add item to ElectricityProviderInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ElectricityProviderInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public function addToElectricityProviderInfo(\CustomerManagement\StructType\ElectricityProviderInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\ElectricityProviderInfo) {
            throw new \InvalidArgumentException(sprintf('The ElectricityProviderInfo property can only contain items of \CustomerManagement\StructType\ElectricityProviderInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ElectricityProviderInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ElectricityProviderInfo
     */
    public function getAttributeName()
    {
        return 'ElectricityProviderInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
