<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceFeaturesOutput StructType
 * @subpackage Structs
 */
class InsuranceFeaturesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The HasInsuranceFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasInsuranceFeatures;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for InsuranceFeaturesOutput
     * @uses InsuranceFeaturesOutput::setSuccess()
     * @uses InsuranceFeaturesOutput::setCustomerID()
     * @uses InsuranceFeaturesOutput::setHasInsuranceFeatures()
     * @uses InsuranceFeaturesOutput::setErrorMessage()
     * @param bool $success
     * @param int $customerID
     * @param bool $hasInsuranceFeatures
     * @param string $errorMessage
     */
    public function __construct($success = null, $customerID = null, $hasInsuranceFeatures = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setCustomerID($customerID)
            ->setHasInsuranceFeatures($hasInsuranceFeatures)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\InsuranceFeaturesOutput
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \CustomerManagement\StructType\InsuranceFeaturesOutput
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get HasInsuranceFeatures value
     * @return bool
     */
    public function getHasInsuranceFeatures()
    {
        return $this->HasInsuranceFeatures;
    }
    /**
     * Set HasInsuranceFeatures value
     * @param bool $hasInsuranceFeatures
     * @return \CustomerManagement\StructType\InsuranceFeaturesOutput
     */
    public function setHasInsuranceFeatures($hasInsuranceFeatures = null)
    {
        $this->HasInsuranceFeatures = $hasInsuranceFeatures;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\InsuranceFeaturesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\InsuranceFeaturesOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
