<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSignalStrengthInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfSignalStrengthInfo extends AbstractStructArrayBase
{
    /**
     * The SignalStrengthInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\SignalStrengthInfo[]
     */
    public $SignalStrengthInfo;
    /**
     * Constructor method for ArrayOfSignalStrengthInfo
     * @uses ArrayOfSignalStrengthInfo::setSignalStrengthInfo()
     * @param \CustomerManagement\StructType\SignalStrengthInfo[] $signalStrengthInfo
     */
    public function __construct(array $signalStrengthInfo = array())
    {
        $this
            ->setSignalStrengthInfo($signalStrengthInfo);
    }
    /**
     * Get SignalStrengthInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\SignalStrengthInfo[]|null
     */
    public function getSignalStrengthInfo()
    {
        return isset($this->SignalStrengthInfo) ? $this->SignalStrengthInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSignalStrengthInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignalStrengthInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignalStrengthInfoForArrayConstraintsFromSetSignalStrengthInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSignalStrengthInfoSignalStrengthInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSignalStrengthInfoSignalStrengthInfoItem instanceof \CustomerManagement\StructType\SignalStrengthInfo) {
                $invalidValues[] = is_object($arrayOfSignalStrengthInfoSignalStrengthInfoItem) ? get_class($arrayOfSignalStrengthInfoSignalStrengthInfoItem) : sprintf('%s(%s)', gettype($arrayOfSignalStrengthInfoSignalStrengthInfoItem), var_export($arrayOfSignalStrengthInfoSignalStrengthInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SignalStrengthInfo property can only contain items of type \CustomerManagement\StructType\SignalStrengthInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SignalStrengthInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SignalStrengthInfo[] $signalStrengthInfo
     * @return \CustomerManagement\ArrayType\ArrayOfSignalStrengthInfo
     */
    public function setSignalStrengthInfo(array $signalStrengthInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($signalStrengthInfoArrayErrorMessage = self::validateSignalStrengthInfoForArrayConstraintsFromSetSignalStrengthInfo($signalStrengthInfo))) {
            throw new \InvalidArgumentException($signalStrengthInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($signalStrengthInfo) || (is_array($signalStrengthInfo) && empty($signalStrengthInfo))) {
            unset($this->SignalStrengthInfo);
        } else {
            $this->SignalStrengthInfo = $signalStrengthInfo;
        }
        return $this;
    }
    /**
     * Add item to SignalStrengthInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SignalStrengthInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfSignalStrengthInfo
     */
    public function addToSignalStrengthInfo(\CustomerManagement\StructType\SignalStrengthInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\SignalStrengthInfo) {
            throw new \InvalidArgumentException(sprintf('The SignalStrengthInfo property can only contain items of type \CustomerManagement\StructType\SignalStrengthInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SignalStrengthInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\SignalStrengthInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\SignalStrengthInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\SignalStrengthInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\SignalStrengthInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\SignalStrengthInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SignalStrengthInfo
     */
    public function getAttributeName()
    {
        return 'SignalStrengthInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfSignalStrengthInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
