<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginInfo StructType
 * @subpackage Structs
 */
class LoginInfo extends AbstractStructBase
{
    /**
     * The LoginId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The LoginEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginEmailAddress;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Roles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $Roles;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * Constructor method for LoginInfo
     * @uses LoginInfo::setLoginId()
     * @uses LoginInfo::setLoginEmailAddress()
     * @uses LoginInfo::setLoginName()
     * @uses LoginInfo::setRoles()
     * @uses LoginInfo::setLoginNameAtAuthenticationProvider()
     * @param int $loginId
     * @param string $loginEmailAddress
     * @param string $loginName
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @param string $loginNameAtAuthenticationProvider
     */
    public function __construct($loginId = null, $loginEmailAddress = null, $loginName = null, \CustomerManagement\ArrayType\ArrayOfInt $roles = null, $loginNameAtAuthenticationProvider = null)
    {
        $this
            ->setLoginId($loginId)
            ->setLoginEmailAddress($loginEmailAddress)
            ->setLoginName($loginName)
            ->setRoles($roles)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider);
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !is_numeric($loginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get LoginEmailAddress value
     * @return string|null
     */
    public function getLoginEmailAddress()
    {
        return $this->LoginEmailAddress;
    }
    /**
     * Set LoginEmailAddress value
     * @param string $loginEmailAddress
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public function setLoginEmailAddress($loginEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($loginEmailAddress) && !is_string($loginEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginEmailAddress)), __LINE__);
        }
        $this->LoginEmailAddress = $loginEmailAddress;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Roles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public function setRoles(\CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\LoginInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
