<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSummary StructType
 * @subpackage Structs
 */
class CustomerSummary extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The CustomerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerType;
    /**
     * The UnitDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitDescription;
    /**
     * The CustomerRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $CustomerRoles;
    /**
     * The InstallAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallAddress;
    /**
     * Constructor method for CustomerSummary
     * @uses CustomerSummary::setCustomerId()
     * @uses CustomerSummary::setCustomerType()
     * @uses CustomerSummary::setUnitDescription()
     * @uses CustomerSummary::setCustomerRoles()
     * @uses CustomerSummary::setInstallAddress()
     * @param int $customerId
     * @param string $customerType
     * @param string $unitDescription
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerRoles
     * @param \CustomerManagement\StructType\Address $installAddress
     */
    public function __construct($customerId = null, $customerType = null, $unitDescription = null, \CustomerManagement\ArrayType\ArrayOfInt $customerRoles = null, \CustomerManagement\StructType\Address $installAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCustomerType($customerType)
            ->setUnitDescription($unitDescription)
            ->setCustomerRoles($customerRoles)
            ->setInstallAddress($installAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerType
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid($customerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $customerType, implode(', ', \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues())), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get UnitDescription value
     * @return string|null
     */
    public function getUnitDescription()
    {
        return $this->UnitDescription;
    }
    /**
     * Set UnitDescription value
     * @param string $unitDescription
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setUnitDescription($unitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescription) && !is_string($unitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitDescription)), __LINE__);
        }
        $this->UnitDescription = $unitDescription;
        return $this;
    }
    /**
     * Get CustomerRoles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getCustomerRoles()
    {
        return $this->CustomerRoles;
    }
    /**
     * Set CustomerRoles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $customerRoles
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setCustomerRoles(\CustomerManagement\ArrayType\ArrayOfInt $customerRoles = null)
    {
        $this->CustomerRoles = $customerRoles;
        return $this;
    }
    /**
     * Get InstallAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallAddress()
    {
        return $this->InstallAddress;
    }
    /**
     * Set InstallAddress value
     * @param \CustomerManagement\StructType\Address $installAddress
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public function setInstallAddress(\CustomerManagement\StructType\Address $installAddress = null)
    {
        $this->InstallAddress = $installAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
