<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPackage StructType
 * @subpackage Structs
 */
class CustomerPackage extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The TermDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TermDate;
    /**
     * The ServicePlanRecurrencePeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServicePlanRecurrencePeriod;
    /**
     * The DatabindingPackageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabindingPackageName;
    /**
     * Constructor method for CustomerPackage
     * @uses CustomerPackage::setStartDate()
     * @uses CustomerPackage::setTermDate()
     * @uses CustomerPackage::setServicePlanRecurrencePeriod()
     * @uses CustomerPackage::setDatabindingPackageName()
     * @param string $startDate
     * @param string $termDate
     * @param string $servicePlanRecurrencePeriod
     * @param string $databindingPackageName
     */
    public function __construct($startDate = null, $termDate = null, $servicePlanRecurrencePeriod = null, $databindingPackageName = null)
    {
        $this
            ->setStartDate($startDate)
            ->setTermDate($termDate)
            ->setServicePlanRecurrencePeriod($servicePlanRecurrencePeriod)
            ->setDatabindingPackageName($databindingPackageName);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \CustomerManagement\StructType\CustomerPackage
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get TermDate value
     * @return string
     */
    public function getTermDate()
    {
        return $this->TermDate;
    }
    /**
     * Set TermDate value
     * @param string $termDate
     * @return \CustomerManagement\StructType\CustomerPackage
     */
    public function setTermDate($termDate = null)
    {
        // validation for constraint: string
        if (!is_null($termDate) && !is_string($termDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($termDate)), __LINE__);
        }
        $this->TermDate = $termDate;
        return $this;
    }
    /**
     * Get ServicePlanRecurrencePeriod value
     * @return string
     */
    public function getServicePlanRecurrencePeriod()
    {
        return $this->ServicePlanRecurrencePeriod;
    }
    /**
     * Set ServicePlanRecurrencePeriod value
     * @uses \CustomerManagement\EnumType\ServicePlanRecurrencePeriodEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ServicePlanRecurrencePeriodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePlanRecurrencePeriod
     * @return \CustomerManagement\StructType\CustomerPackage
     */
    public function setServicePlanRecurrencePeriod($servicePlanRecurrencePeriod = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ServicePlanRecurrencePeriodEnum::valueIsValid($servicePlanRecurrencePeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicePlanRecurrencePeriod, implode(', ', \CustomerManagement\EnumType\ServicePlanRecurrencePeriodEnum::getValidValues())), __LINE__);
        }
        $this->ServicePlanRecurrencePeriod = $servicePlanRecurrencePeriod;
        return $this;
    }
    /**
     * Get DatabindingPackageName value
     * @return string|null
     */
    public function getDatabindingPackageName()
    {
        return $this->DatabindingPackageName;
    }
    /**
     * Set DatabindingPackageName value
     * @param string $databindingPackageName
     * @return \CustomerManagement\StructType\CustomerPackage
     */
    public function setDatabindingPackageName($databindingPackageName = null)
    {
        // validation for constraint: string
        if (!is_null($databindingPackageName) && !is_string($databindingPackageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databindingPackageName)), __LINE__);
        }
        $this->DatabindingPackageName = $databindingPackageName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
