<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerForDealer StructType
 * @subpackage Structs
 */
class CreateCustomerForDealer extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $dealerId;
    /**
     * The input
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\CreateCustomerInput
     */
    public $input;
    /**
     * Constructor method for CreateCustomerForDealer
     * @uses CreateCustomerForDealer::setDealerId()
     * @uses CreateCustomerForDealer::setInput()
     * @param int $dealerId
     * @param \CustomerManagement\StructType\CreateCustomerInput $input
     */
    public function __construct($dealerId = null, \CustomerManagement\StructType\CreateCustomerInput $input = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setInput($input);
    }
    /**
     * Get dealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->dealerId;
    }
    /**
     * Set dealerId value
     * @param int $dealerId
     * @return \CustomerManagement\StructType\CreateCustomerForDealer
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !is_numeric($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dealerId)), __LINE__);
        }
        $this->dealerId = $dealerId;
        return $this;
    }
    /**
     * Get input value
     * @return \CustomerManagement\StructType\CreateCustomerInput|null
     */
    public function getInput()
    {
        return $this->input;
    }
    /**
     * Set input value
     * @param \CustomerManagement\StructType\CreateCustomerInput $input
     * @return \CustomerManagement\StructType\CreateCustomerForDealer
     */
    public function setInput(\CustomerManagement\StructType\CreateCustomerInput $input = null)
    {
        $this->input = $input;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CreateCustomerForDealer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
