<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerTroubleCondition StructType
 * @subpackage Structs
 */
class CustomerTroubleCondition extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The DeviceIdInPanel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceIdInPanel;
    /**
     * The DeviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceType;
    /**
     * The DeviceDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceDesc;
    /**
     * The TroubleConditions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates
     */
    public $TroubleConditions;
    /**
     * Constructor method for CustomerTroubleCondition
     * @uses CustomerTroubleCondition::setDeviceId()
     * @uses CustomerTroubleCondition::setDeviceIdInPanel()
     * @uses CustomerTroubleCondition::setDeviceType()
     * @uses CustomerTroubleCondition::setDeviceDesc()
     * @uses CustomerTroubleCondition::setTroubleConditions()
     * @param int $deviceId
     * @param int $deviceIdInPanel
     * @param string $deviceType
     * @param string $deviceDesc
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions
     */
    public function __construct($deviceId = null, $deviceIdInPanel = null, $deviceType = null, $deviceDesc = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setDeviceIdInPanel($deviceIdInPanel)
            ->setDeviceType($deviceType)
            ->setDeviceDesc($deviceDesc)
            ->setTroubleConditions($troubleConditions);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !is_numeric($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get DeviceIdInPanel value
     * @return int
     */
    public function getDeviceIdInPanel()
    {
        return $this->DeviceIdInPanel;
    }
    /**
     * Set DeviceIdInPanel value
     * @param int $deviceIdInPanel
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceIdInPanel($deviceIdInPanel = null)
    {
        // validation for constraint: int
        if (!is_null($deviceIdInPanel) && !is_numeric($deviceIdInPanel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deviceIdInPanel)), __LINE__);
        }
        $this->DeviceIdInPanel = $deviceIdInPanel;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceType, implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get DeviceDesc value
     * @return string|null
     */
    public function getDeviceDesc()
    {
        return $this->DeviceDesc;
    }
    /**
     * Set DeviceDesc value
     * @param string $deviceDesc
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setDeviceDesc($deviceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDesc) && !is_string($deviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceDesc)), __LINE__);
        }
        $this->DeviceDesc = $deviceDesc;
        return $this;
    }
    /**
     * Get TroubleConditions value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates|null
     */
    public function getTroubleConditions()
    {
        return $this->TroubleConditions;
    }
    /**
     * Set TroubleConditions value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public function setTroubleConditions(\CustomerManagement\ArrayType\ArrayOfTroubleConditionWithDates $troubleConditions = null)
    {
        $this->TroubleConditions = $troubleConditions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerTroubleCondition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
