<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAccountOutput StructType
 * @subpackage Structs
 */
class TransferAccountOutput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SuccessfullyTransferred
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SuccessfullyTransferred;
    /**
     * The SafeToTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SafeToTransfer;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for TransferAccountOutput
     * @uses TransferAccountOutput::setCustomerId()
     * @uses TransferAccountOutput::setSuccessfullyTransferred()
     * @uses TransferAccountOutput::setSafeToTransfer()
     * @uses TransferAccountOutput::setReason()
     * @param int $customerId
     * @param bool $successfullyTransferred
     * @param bool $safeToTransfer
     * @param string $reason
     */
    public function __construct($customerId = null, $successfullyTransferred = null, $safeToTransfer = null, $reason = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSuccessfullyTransferred($successfullyTransferred)
            ->setSafeToTransfer($safeToTransfer)
            ->setReason($reason);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SuccessfullyTransferred value
     * @return bool
     */
    public function getSuccessfullyTransferred()
    {
        return $this->SuccessfullyTransferred;
    }
    /**
     * Set SuccessfullyTransferred value
     * @param bool $successfullyTransferred
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setSuccessfullyTransferred($successfullyTransferred = null)
    {
        $this->SuccessfullyTransferred = $successfullyTransferred;
        return $this;
    }
    /**
     * Get SafeToTransfer value
     * @return bool
     */
    public function getSafeToTransfer()
    {
        return $this->SafeToTransfer;
    }
    /**
     * Set SafeToTransfer value
     * @param bool $safeToTransfer
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setSafeToTransfer($safeToTransfer = null)
    {
        $this->SafeToTransfer = $safeToTransfer;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
