<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for TimeZoneEnum EnumType
 * @subpackage Enumerations
 */
class TimeZoneEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Eastern'
     * @return string 'Eastern'
     */
    const VALUE_EASTERN = 'Eastern';
    /**
     * Constant for value 'Central'
     * @return string 'Central'
     */
    const VALUE_CENTRAL = 'Central';
    /**
     * Constant for value 'Mountain'
     * @return string 'Mountain'
     */
    const VALUE_MOUNTAIN = 'Mountain';
    /**
     * Constant for value 'Pacific'
     * @return string 'Pacific'
     */
    const VALUE_PACIFIC = 'Pacific';
    /**
     * Constant for value 'Alaska'
     * @return string 'Alaska'
     */
    const VALUE_ALASKA = 'Alaska';
    /**
     * Constant for value 'Hawaii'
     * @return string 'Hawaii'
     */
    const VALUE_HAWAII = 'Hawaii';
    /**
     * Constant for value 'WestSamoa'
     * @return string 'WestSamoa'
     */
    const VALUE_WEST_SAMOA = 'WestSamoa';
    /**
     * Constant for value 'AtlanticNoDST'
     * @return string 'AtlanticNoDST'
     */
    const VALUE_ATLANTIC_NO_DST = 'AtlanticNoDST';
    /**
     * Constant for value 'Guam'
     * @return string 'Guam'
     */
    const VALUE_GUAM = 'Guam';
    /**
     * Constant for value 'Palau'
     * @return string 'Palau'
     */
    const VALUE_PALAU = 'Palau';
    /**
     * Constant for value 'Arizona'
     * @return string 'Arizona'
     */
    const VALUE_ARIZONA = 'Arizona';
    /**
     * Constant for value 'Newfoundland'
     * @return string 'Newfoundland'
     */
    const VALUE_NEWFOUNDLAND = 'Newfoundland';
    /**
     * Constant for value 'Atlantic'
     * @return string 'Atlantic'
     */
    const VALUE_ATLANTIC = 'Atlantic';
    /**
     * Constant for value 'EasternNoDST'
     * @return string 'EasternNoDST'
     */
    const VALUE_EASTERN_NO_DST = 'EasternNoDST';
    /**
     * Constant for value 'CentralNoDST'
     * @return string 'CentralNoDST'
     */
    const VALUE_CENTRAL_NO_DST = 'CentralNoDST';
    /**
     * Constant for value 'HawaiiAleutian'
     * @return string 'HawaiiAleutian'
     */
    const VALUE_HAWAII_ALEUTIAN = 'HawaiiAleutian';
    /**
     * Constant for value 'WakeIsland'
     * @return string 'WakeIsland'
     */
    const VALUE_WAKE_ISLAND = 'WakeIsland';
    /**
     * Constant for value 'Pohnpei'
     * @return string 'Pohnpei'
     */
    const VALUE_POHNPEI = 'Pohnpei';
    /**
     * Constant for value 'Brasilia'
     * @return string 'Brasilia'
     */
    const VALUE_BRASILIA = 'Brasilia';
    /**
     * Constant for value 'CentralBrazilian'
     * @return string 'CentralBrazilian'
     */
    const VALUE_CENTRAL_BRAZILIAN = 'CentralBrazilian';
    /**
     * Constant for value 'Amazon'
     * @return string 'Amazon'
     */
    const VALUE_AMAZON = 'Amazon';
    /**
     * Constant for value 'BraziliaNoDST'
     * @return string 'BraziliaNoDST'
     */
    const VALUE_BRAZILIA_NO_DST = 'BraziliaNoDST';
    /**
     * Constant for value 'Fernando'
     * @return string 'Fernando'
     */
    const VALUE_FERNANDO = 'Fernando';
    /**
     * Constant for value 'Muchosransk'
     * @return string 'Muchosransk'
     */
    const VALUE_MUCHOSRANSK = 'Muchosransk';
    /**
     * Constant for value 'CentralMexico'
     * @return string 'CentralMexico'
     */
    const VALUE_CENTRAL_MEXICO = 'CentralMexico';
    /**
     * Constant for value 'MountainMexico'
     * @return string 'MountainMexico'
     */
    const VALUE_MOUNTAIN_MEXICO = 'MountainMexico';
    /**
     * Constant for value 'MountainMexicoNoDST'
     * @return string 'MountainMexicoNoDST'
     */
    const VALUE_MOUNTAIN_MEXICO_NO_DST = 'MountainMexicoNoDST';
    /**
     * Constant for value 'PacificMexico'
     * @return string 'PacificMexico'
     */
    const VALUE_PACIFIC_MEXICO = 'PacificMexico';
    /**
     * Constant for value 'SouthAfrican'
     * @return string 'SouthAfrican'
     */
    const VALUE_SOUTH_AFRICAN = 'SouthAfrican';
    /**
     * Constant for value 'Chile'
     * @return string 'Chile'
     */
    const VALUE_CHILE = 'Chile';
    /**
     * Constant for value 'EasterIsland'
     * @return string 'EasterIsland'
     */
    const VALUE_EASTER_ISLAND = 'EasterIsland';
    /**
     * Constant for value 'Argentina'
     * @return string 'Argentina'
     */
    const VALUE_ARGENTINA = 'Argentina';
    /**
     * Constant for value 'Colombia'
     * @return string 'Colombia'
     */
    const VALUE_COLOMBIA = 'Colombia';
    /**
     * Constant for value 'NewZealand'
     * @return string 'NewZealand'
     */
    const VALUE_NEW_ZEALAND = 'NewZealand';
    /**
     * Constant for value 'Turkey'
     * @return string 'Turkey'
     */
    const VALUE_TURKEY = 'Turkey';
    /**
     * Constant for value 'CentralAfrica'
     * @return string 'CentralAfrica'
     */
    const VALUE_CENTRAL_AFRICA = 'CentralAfrica';
    /**
     * Constant for value 'Venezuela'
     * @return string 'Venezuela'
     */
    const VALUE_VENEZUELA = 'Venezuela';
    /**
     * Constant for value 'Peru'
     * @return string 'Peru'
     */
    const VALUE_PERU = 'Peru';
    /**
     * Constant for value 'Ecuador'
     * @return string 'Ecuador'
     */
    const VALUE_ECUADOR = 'Ecuador';
    /**
     * Constant for value 'AustralianEastern'
     * @return string 'AustralianEastern'
     */
    const VALUE_AUSTRALIAN_EASTERN = 'AustralianEastern';
    /**
     * Constant for value 'AustralianCentral'
     * @return string 'AustralianCentral'
     */
    const VALUE_AUSTRALIAN_CENTRAL = 'AustralianCentral';
    /**
     * Constant for value 'ChristmasIsland'
     * @return string 'ChristmasIsland'
     */
    const VALUE_CHRISTMAS_ISLAND = 'ChristmasIsland';
    /**
     * Constant for value 'Norfolk'
     * @return string 'Norfolk'
     */
    const VALUE_NORFOLK = 'Norfolk';
    /**
     * Constant for value 'AustralianWestern'
     * @return string 'AustralianWestern'
     */
    const VALUE_AUSTRALIAN_WESTERN = 'AustralianWestern';
    /**
     * Constant for value 'GMT'
     * @return string 'GMT'
     */
    const VALUE_GMT = 'GMT';
    /**
     * Constant for value 'CentralEuropean'
     * @return string 'CentralEuropean'
     */
    const VALUE_CENTRAL_EUROPEAN = 'CentralEuropean';
    /**
     * Constant for value 'WesternEuropean'
     * @return string 'WesternEuropean'
     */
    const VALUE_WESTERN_EUROPEAN = 'WesternEuropean';
    /**
     * Constant for value 'GMTNoDST'
     * @return string 'GMTNoDST'
     */
    const VALUE_GMTNO_DST = 'GMTNoDST';
    /**
     * Constant for value 'UruguayTime'
     * @return string 'UruguayTime'
     */
    const VALUE_URUGUAY_TIME = 'UruguayTime';
    /**
     * Constant for value 'ParaguayTime'
     * @return string 'ParaguayTime'
     */
    const VALUE_PARAGUAY_TIME = 'ParaguayTime';
    /**
     * Constant for value 'BoliviaTime'
     * @return string 'BoliviaTime'
     */
    const VALUE_BOLIVIA_TIME = 'BoliviaTime';
    /**
     * Constant for value 'WestAfricaTime'
     * @return string 'WestAfricaTime'
     */
    const VALUE_WEST_AFRICA_TIME = 'WestAfricaTime';
    /**
     * Constant for value 'AustralianEasternNoDst'
     * @return string 'AustralianEasternNoDst'
     */
    const VALUE_AUSTRALIAN_EASTERN_NO_DST = 'AustralianEasternNoDst';
    /**
     * Constant for value 'AustralianCentralNoDst'
     * @return string 'AustralianCentralNoDst'
     */
    const VALUE_AUSTRALIAN_CENTRAL_NO_DST = 'AustralianCentralNoDst';
    /**
     * Constant for value 'IndiaStandardTime'
     * @return string 'IndiaStandardTime'
     */
    const VALUE_INDIA_STANDARD_TIME = 'IndiaStandardTime';
    /**
     * Constant for value 'EasternMexico'
     * @return string 'EasternMexico'
     */
    const VALUE_EASTERN_MEXICO = 'EasternMexico';
    /**
     * Constant for value 'IndochinaTime'
     * @return string 'IndochinaTime'
     */
    const VALUE_INDOCHINA_TIME = 'IndochinaTime';
    /**
     * Constant for value 'Fiji'
     * @return string 'Fiji'
     */
    const VALUE_FIJI = 'Fiji';
    /**
     * Constant for value 'GreenwichMeanTimeIreland'
     * @return string 'GreenwichMeanTimeIreland'
     */
    const VALUE_GREENWICH_MEAN_TIME_IRELAND = 'GreenwichMeanTimeIreland';
    /**
     * Constant for value 'MalaysiaTime'
     * @return string 'MalaysiaTime'
     */
    const VALUE_MALAYSIA_TIME = 'MalaysiaTime';
    /**
     * Constant for value 'TestTimezone'
     * @return string 'TestTimezone'
     */
    const VALUE_TEST_TIMEZONE = 'TestTimezone';
    /**
     * Constant for value 'GulfStandardTime'
     * @return string 'GulfStandardTime'
     */
    const VALUE_GULF_STANDARD_TIME = 'GulfStandardTime';
    /**
     * Constant for value 'PhilippineTime'
     * @return string 'PhilippineTime'
     */
    const VALUE_PHILIPPINE_TIME = 'PhilippineTime';
    /**
     * Constant for value 'EasternEuropeanTime'
     * @return string 'EasternEuropeanTime'
     */
    const VALUE_EASTERN_EUROPEAN_TIME = 'EasternEuropeanTime';
    /**
     * Constant for value 'ArabStandardTime'
     * @return string 'ArabStandardTime'
     */
    const VALUE_ARAB_STANDARD_TIME = 'ArabStandardTime';
    /**
     * Constant for value 'IsraelStandardTime'
     * @return string 'IsraelStandardTime'
     */
    const VALUE_ISRAEL_STANDARD_TIME = 'IsraelStandardTime';
    /**
     * Constant for value 'SingaporeTime'
     * @return string 'SingaporeTime'
     */
    const VALUE_SINGAPORE_TIME = 'SingaporeTime';
    /**
     * Constant for value 'CentralEuropeanTime'
     * @return string 'CentralEuropeanTime'
     */
    const VALUE_CENTRAL_EUROPEAN_TIME = 'CentralEuropeanTime';
    /**
     * Constant for value 'GTBStandardTime'
     * @return string 'GTBStandardTime'
     */
    const VALUE_GTBSTANDARD_TIME = 'GTBStandardTime';
    /**
     * Constant for value 'GuyanaTime'
     * @return string 'GuyanaTime'
     */
    const VALUE_GUYANA_TIME = 'GuyanaTime';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_EASTERN
     * @uses self::VALUE_CENTRAL
     * @uses self::VALUE_MOUNTAIN
     * @uses self::VALUE_PACIFIC
     * @uses self::VALUE_ALASKA
     * @uses self::VALUE_HAWAII
     * @uses self::VALUE_WEST_SAMOA
     * @uses self::VALUE_ATLANTIC_NO_DST
     * @uses self::VALUE_GUAM
     * @uses self::VALUE_PALAU
     * @uses self::VALUE_ARIZONA
     * @uses self::VALUE_NEWFOUNDLAND
     * @uses self::VALUE_ATLANTIC
     * @uses self::VALUE_EASTERN_NO_DST
     * @uses self::VALUE_CENTRAL_NO_DST
     * @uses self::VALUE_HAWAII_ALEUTIAN
     * @uses self::VALUE_WAKE_ISLAND
     * @uses self::VALUE_POHNPEI
     * @uses self::VALUE_BRASILIA
     * @uses self::VALUE_CENTRAL_BRAZILIAN
     * @uses self::VALUE_AMAZON
     * @uses self::VALUE_BRAZILIA_NO_DST
     * @uses self::VALUE_FERNANDO
     * @uses self::VALUE_MUCHOSRANSK
     * @uses self::VALUE_CENTRAL_MEXICO
     * @uses self::VALUE_MOUNTAIN_MEXICO
     * @uses self::VALUE_MOUNTAIN_MEXICO_NO_DST
     * @uses self::VALUE_PACIFIC_MEXICO
     * @uses self::VALUE_SOUTH_AFRICAN
     * @uses self::VALUE_CHILE
     * @uses self::VALUE_EASTER_ISLAND
     * @uses self::VALUE_ARGENTINA
     * @uses self::VALUE_COLOMBIA
     * @uses self::VALUE_NEW_ZEALAND
     * @uses self::VALUE_TURKEY
     * @uses self::VALUE_CENTRAL_AFRICA
     * @uses self::VALUE_VENEZUELA
     * @uses self::VALUE_PERU
     * @uses self::VALUE_ECUADOR
     * @uses self::VALUE_AUSTRALIAN_EASTERN
     * @uses self::VALUE_AUSTRALIAN_CENTRAL
     * @uses self::VALUE_CHRISTMAS_ISLAND
     * @uses self::VALUE_NORFOLK
     * @uses self::VALUE_AUSTRALIAN_WESTERN
     * @uses self::VALUE_GMT
     * @uses self::VALUE_CENTRAL_EUROPEAN
     * @uses self::VALUE_WESTERN_EUROPEAN
     * @uses self::VALUE_GMTNO_DST
     * @uses self::VALUE_URUGUAY_TIME
     * @uses self::VALUE_PARAGUAY_TIME
     * @uses self::VALUE_BOLIVIA_TIME
     * @uses self::VALUE_WEST_AFRICA_TIME
     * @uses self::VALUE_AUSTRALIAN_EASTERN_NO_DST
     * @uses self::VALUE_AUSTRALIAN_CENTRAL_NO_DST
     * @uses self::VALUE_INDIA_STANDARD_TIME
     * @uses self::VALUE_EASTERN_MEXICO
     * @uses self::VALUE_INDOCHINA_TIME
     * @uses self::VALUE_FIJI
     * @uses self::VALUE_GREENWICH_MEAN_TIME_IRELAND
     * @uses self::VALUE_MALAYSIA_TIME
     * @uses self::VALUE_TEST_TIMEZONE
     * @uses self::VALUE_GULF_STANDARD_TIME
     * @uses self::VALUE_PHILIPPINE_TIME
     * @uses self::VALUE_EASTERN_EUROPEAN_TIME
     * @uses self::VALUE_ARAB_STANDARD_TIME
     * @uses self::VALUE_ISRAEL_STANDARD_TIME
     * @uses self::VALUE_SINGAPORE_TIME
     * @uses self::VALUE_CENTRAL_EUROPEAN_TIME
     * @uses self::VALUE_GTBSTANDARD_TIME
     * @uses self::VALUE_GUYANA_TIME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_EASTERN,
            self::VALUE_CENTRAL,
            self::VALUE_MOUNTAIN,
            self::VALUE_PACIFIC,
            self::VALUE_ALASKA,
            self::VALUE_HAWAII,
            self::VALUE_WEST_SAMOA,
            self::VALUE_ATLANTIC_NO_DST,
            self::VALUE_GUAM,
            self::VALUE_PALAU,
            self::VALUE_ARIZONA,
            self::VALUE_NEWFOUNDLAND,
            self::VALUE_ATLANTIC,
            self::VALUE_EASTERN_NO_DST,
            self::VALUE_CENTRAL_NO_DST,
            self::VALUE_HAWAII_ALEUTIAN,
            self::VALUE_WAKE_ISLAND,
            self::VALUE_POHNPEI,
            self::VALUE_BRASILIA,
            self::VALUE_CENTRAL_BRAZILIAN,
            self::VALUE_AMAZON,
            self::VALUE_BRAZILIA_NO_DST,
            self::VALUE_FERNANDO,
            self::VALUE_MUCHOSRANSK,
            self::VALUE_CENTRAL_MEXICO,
            self::VALUE_MOUNTAIN_MEXICO,
            self::VALUE_MOUNTAIN_MEXICO_NO_DST,
            self::VALUE_PACIFIC_MEXICO,
            self::VALUE_SOUTH_AFRICAN,
            self::VALUE_CHILE,
            self::VALUE_EASTER_ISLAND,
            self::VALUE_ARGENTINA,
            self::VALUE_COLOMBIA,
            self::VALUE_NEW_ZEALAND,
            self::VALUE_TURKEY,
            self::VALUE_CENTRAL_AFRICA,
            self::VALUE_VENEZUELA,
            self::VALUE_PERU,
            self::VALUE_ECUADOR,
            self::VALUE_AUSTRALIAN_EASTERN,
            self::VALUE_AUSTRALIAN_CENTRAL,
            self::VALUE_CHRISTMAS_ISLAND,
            self::VALUE_NORFOLK,
            self::VALUE_AUSTRALIAN_WESTERN,
            self::VALUE_GMT,
            self::VALUE_CENTRAL_EUROPEAN,
            self::VALUE_WESTERN_EUROPEAN,
            self::VALUE_GMTNO_DST,
            self::VALUE_URUGUAY_TIME,
            self::VALUE_PARAGUAY_TIME,
            self::VALUE_BOLIVIA_TIME,
            self::VALUE_WEST_AFRICA_TIME,
            self::VALUE_AUSTRALIAN_EASTERN_NO_DST,
            self::VALUE_AUSTRALIAN_CENTRAL_NO_DST,
            self::VALUE_INDIA_STANDARD_TIME,
            self::VALUE_EASTERN_MEXICO,
            self::VALUE_INDOCHINA_TIME,
            self::VALUE_FIJI,
            self::VALUE_GREENWICH_MEAN_TIME_IRELAND,
            self::VALUE_MALAYSIA_TIME,
            self::VALUE_TEST_TIMEZONE,
            self::VALUE_GULF_STANDARD_TIME,
            self::VALUE_PHILIPPINE_TIME,
            self::VALUE_EASTERN_EUROPEAN_TIME,
            self::VALUE_ARAB_STANDARD_TIME,
            self::VALUE_ISRAEL_STANDARD_TIME,
            self::VALUE_SINGAPORE_TIME,
            self::VALUE_CENTRAL_EUROPEAN_TIME,
            self::VALUE_GTBSTANDARD_TIME,
            self::VALUE_GUYANA_TIME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
