<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for ImageSensorAutoUploadRuleTypeEnum EnumType
 * @subpackage Enumerations
 */
class ImageSensorAutoUploadRuleTypeEnum
{
    /**
     * Constant for value 'DailyView'
     * @return string 'DailyView'
     */
    const VALUE_DAILY_VIEW = 'DailyView';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAILY_VIEW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAILY_VIEW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
