<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModemInfo StructType
 * @subpackage Structs
 */
class ModemInfo extends AbstractStructBase
{
    /**
     * The FirmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FirmwareVersion;
    /**
     * The Network
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Network;
    /**
     * The TwoWayVoiceCapable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TwoWayVoiceCapable;
    /**
     * The RadioNetworkType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RadioNetworkType;
    /**
     * The ModemSerial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerial;
    /**
     * Constructor method for ModemInfo
     * @uses ModemInfo::setFirmwareVersion()
     * @uses ModemInfo::setNetwork()
     * @uses ModemInfo::setTwoWayVoiceCapable()
     * @uses ModemInfo::setRadioNetworkType()
     * @uses ModemInfo::setModemSerial()
     * @param int $firmwareVersion
     * @param string $network
     * @param bool $twoWayVoiceCapable
     * @param string $radioNetworkType
     * @param string $modemSerial
     */
    public function __construct($firmwareVersion = null, $network = null, $twoWayVoiceCapable = null, $radioNetworkType = null, $modemSerial = null)
    {
        $this
            ->setFirmwareVersion($firmwareVersion)
            ->setNetwork($network)
            ->setTwoWayVoiceCapable($twoWayVoiceCapable)
            ->setRadioNetworkType($radioNetworkType)
            ->setModemSerial($modemSerial);
    }
    /**
     * Get FirmwareVersion value
     * @return int
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param int $firmwareVersion
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: int
        if (!is_null($firmwareVersion) && !is_numeric($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get Network value
     * @return string
     */
    public function getNetwork()
    {
        return $this->Network;
    }
    /**
     * Set Network value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $network
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($network)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $network, implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->Network = $network;
        return $this;
    }
    /**
     * Get TwoWayVoiceCapable value
     * @return bool
     */
    public function getTwoWayVoiceCapable()
    {
        return $this->TwoWayVoiceCapable;
    }
    /**
     * Set TwoWayVoiceCapable value
     * @param bool $twoWayVoiceCapable
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setTwoWayVoiceCapable($twoWayVoiceCapable = null)
    {
        $this->TwoWayVoiceCapable = $twoWayVoiceCapable;
        return $this;
    }
    /**
     * Get RadioNetworkType value
     * @return string
     */
    public function getRadioNetworkType()
    {
        return $this->RadioNetworkType;
    }
    /**
     * Set RadioNetworkType value
     * @uses \CustomerManagement\EnumType\RadioNetworkTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RadioNetworkTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $radioNetworkType
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setRadioNetworkType($radioNetworkType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RadioNetworkTypeEnum::valueIsValid($radioNetworkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $radioNetworkType, implode(', ', \CustomerManagement\EnumType\RadioNetworkTypeEnum::getValidValues())), __LINE__);
        }
        $this->RadioNetworkType = $radioNetworkType;
        return $this;
    }
    /**
     * Get ModemSerial value
     * @return string|null
     */
    public function getModemSerial()
    {
        return $this->ModemSerial;
    }
    /**
     * Set ModemSerial value
     * @param string $modemSerial
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public function setModemSerial($modemSerial = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerial) && !is_string($modemSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modemSerial)), __LINE__);
        }
        $this->ModemSerial = $modemSerial;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ModemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
