<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpgradeSAVToSecurityAccountInput StructType
 * @subpackage Structs
 */
class UpgradeSAVToSecurityAccountInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The NewPackageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NewPackageId;
    /**
     * The PackageTemplateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageTemplateId;
    /**
     * The ForwardingOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForwardingOption;
    /**
     * The PhoneLinePresent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PhoneLinePresent;
    /**
     * The ModemSerial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerial;
    /**
     * The AddOnFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $AddOnFeatures;
    /**
     * The EventGroupsToForward
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $EventGroupsToForward;
    /**
     * The CSAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSAccountNumber;
    /**
     * The CSReceiverNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSReceiverNumber;
    /**
     * Constructor method for UpgradeSAVToSecurityAccountInput
     * @uses UpgradeSAVToSecurityAccountInput::setCustomerId()
     * @uses UpgradeSAVToSecurityAccountInput::setNewPackageId()
     * @uses UpgradeSAVToSecurityAccountInput::setPackageTemplateId()
     * @uses UpgradeSAVToSecurityAccountInput::setForwardingOption()
     * @uses UpgradeSAVToSecurityAccountInput::setPhoneLinePresent()
     * @uses UpgradeSAVToSecurityAccountInput::setModemSerial()
     * @uses UpgradeSAVToSecurityAccountInput::setAddOnFeatures()
     * @uses UpgradeSAVToSecurityAccountInput::setEventGroupsToForward()
     * @uses UpgradeSAVToSecurityAccountInput::setCSAccountNumber()
     * @uses UpgradeSAVToSecurityAccountInput::setCSReceiverNumber()
     * @param int $customerId
     * @param int $newPackageId
     * @param int $packageTemplateId
     * @param string $forwardingOption
     * @param bool $phoneLinePresent
     * @param string $modemSerial
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @param string $cSAccountNumber
     * @param string $cSReceiverNumber
     */
    public function __construct($customerId = null, $newPackageId = null, $packageTemplateId = null, $forwardingOption = null, $phoneLinePresent = null, $modemSerial = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null, $cSAccountNumber = null, $cSReceiverNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPackageId($newPackageId)
            ->setPackageTemplateId($packageTemplateId)
            ->setForwardingOption($forwardingOption)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setModemSerial($modemSerial)
            ->setAddOnFeatures($addOnFeatures)
            ->setEventGroupsToForward($eventGroupsToForward)
            ->setCSAccountNumber($cSAccountNumber)
            ->setCSReceiverNumber($cSReceiverNumber);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NewPackageId value
     * @return int
     */
    public function getNewPackageId()
    {
        return $this->NewPackageId;
    }
    /**
     * Set NewPackageId value
     * @param int $newPackageId
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setNewPackageId($newPackageId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageId) && !is_numeric($newPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newPackageId)), __LINE__);
        }
        $this->NewPackageId = $newPackageId;
        return $this;
    }
    /**
     * Get PackageTemplateId value
     * @return int
     */
    public function getPackageTemplateId()
    {
        return $this->PackageTemplateId;
    }
    /**
     * Set PackageTemplateId value
     * @param int $packageTemplateId
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setPackageTemplateId($packageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTemplateId) && !is_numeric($packageTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageTemplateId)), __LINE__);
        }
        $this->PackageTemplateId = $packageTemplateId;
        return $this;
    }
    /**
     * Get ForwardingOption value
     * @return string
     */
    public function getForwardingOption()
    {
        return $this->ForwardingOption;
    }
    /**
     * Set ForwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forwardingOption
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setForwardingOption($forwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($forwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $forwardingOption, implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->ForwardingOption = $forwardingOption;
        return $this;
    }
    /**
     * Get PhoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->PhoneLinePresent;
    }
    /**
     * Set PhoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneLinePresent) && !is_bool($phoneLinePresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($phoneLinePresent)), __LINE__);
        }
        $this->PhoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get ModemSerial value
     * @return string|null
     */
    public function getModemSerial()
    {
        return $this->ModemSerial;
    }
    /**
     * Set ModemSerial value
     * @param string $modemSerial
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setModemSerial($modemSerial = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerial) && !is_string($modemSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modemSerial)), __LINE__);
        }
        $this->ModemSerial = $modemSerial;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
    /**
     * Get EventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getEventGroupsToForward()
    {
        return $this->EventGroupsToForward;
    }
    /**
     * Set EventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this->EventGroupsToForward = $eventGroupsToForward;
        return $this;
    }
    /**
     * Get CSAccountNumber value
     * @return string|null
     */
    public function getCSAccountNumber()
    {
        return $this->CSAccountNumber;
    }
    /**
     * Set CSAccountNumber value
     * @param string $cSAccountNumber
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setCSAccountNumber($cSAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSAccountNumber) && !is_string($cSAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSAccountNumber)), __LINE__);
        }
        $this->CSAccountNumber = $cSAccountNumber;
        return $this;
    }
    /**
     * Get CSReceiverNumber value
     * @return string|null
     */
    public function getCSReceiverNumber()
    {
        return $this->CSReceiverNumber;
    }
    /**
     * Set CSReceiverNumber value
     * @param string $cSReceiverNumber
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public function setCSReceiverNumber($cSReceiverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSReceiverNumber) && !is_string($cSReceiverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSReceiverNumber)), __LINE__);
        }
        $this->CSReceiverNumber = $cSReceiverNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpgradeSAVToSecurityAccountInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
