<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePrimaryPhone StructType
 * @subpackage Structs
 */
class UpdatePrimaryPhone extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $newPhone;
    /**
     * Constructor method for UpdatePrimaryPhone
     * @uses UpdatePrimaryPhone::setCustomerId()
     * @uses UpdatePrimaryPhone::setNewPhone()
     * @param int $customerId
     * @param string $newPhone
     */
    public function __construct($customerId = null, $newPhone = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPhone($newPhone);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdatePrimaryPhone
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newPhone value
     * @return string|null
     */
    public function getNewPhone()
    {
        return $this->newPhone;
    }
    /**
     * Set newPhone value
     * @param string $newPhone
     * @return \CustomerManagement\StructType\UpdatePrimaryPhone
     */
    public function setNewPhone($newPhone = null)
    {
        // validation for constraint: string
        if (!is_null($newPhone) && !is_string($newPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPhone)), __LINE__);
        }
        $this->newPhone = $newPhone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdatePrimaryPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
