<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CentralStationForwardingOptionEnum EnumType
 * @subpackage Enumerations
 */
class CentralStationForwardingOptionEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Never'
     * @return string 'Never'
     */
    const VALUE_NEVER = 'Never';
    /**
     * Constant for value 'Always'
     * @return string 'Always'
     */
    const VALUE_ALWAYS = 'Always';
    /**
     * Constant for value 'OnlyIfPhoneFails'
     * @return string 'OnlyIfPhoneFails'
     */
    const VALUE_ONLY_IF_PHONE_FAILS = 'OnlyIfPhoneFails';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_ALWAYS
     * @uses self::VALUE_ONLY_IF_PHONE_FAILS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_NEVER,
            self::VALUE_ALWAYS,
            self::VALUE_ONLY_IF_PHONE_FAILS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
