<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * GetCustomerEnergyProgramEligibility
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of all customers within a specific program area.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerEnergyProgramEligibility $parameters
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityResponse|bool
     */
    public function GetCustomerEnergyProgramEligibility(\CustomerManagement\StructType\GetCustomerEnergyProgramEligibility $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerEnergyProgramEligibility($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorLatestCaptureInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Image Sensor Latest Capture info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorLatestCaptureInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorLatestCaptureInfoResponse|bool
     */
    public function GetImageSensorLatestCaptureInfo(\CustomerManagement\StructType\GetImageSensorLatestCaptureInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetImageSensorLatestCaptureInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorUploadsInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Image Sensor number of uploads info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorUploadsInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorUploadsInfoResponse|bool
     */
    public function GetImageSensorUploadsInfo(\CustomerManagement\StructType\GetImageSensorUploadsInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetImageSensorUploadsInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEligibleSensorGroups
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of eligible sensor groups given a unit ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEligibleSensorGroups $parameters
     * @return \CustomerManagement\StructType\GetEligibleSensorGroupsResponse|bool
     */
    public function GetEligibleSensorGroups(\CustomerManagement\StructType\GetEligibleSensorGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEligibleSensorGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEligibleSensorNames
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of eligible sensor names.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEligibleSensorNames $parameters
     * @return \CustomerManagement\StructType\GetEligibleSensorNamesResponse|bool
     */
    public function GetEligibleSensorNames(\CustomerManagement\StructType\GetEligibleSensorNames $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEligibleSensorNames($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserCodes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all user codes for a specific customer. This will return all user codes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetUserCodes $parameters
     * @return \CustomerManagement\StructType\GetUserCodesResponse|bool
     */
    public function GetUserCodes(\CustomerManagement\StructType\GetUserCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableWifiNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all available wifi network names.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAvailableWifiNetworks $parameters
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksResponse|bool
     */
    public function GetAvailableWifiNetworks(\CustomerManagement\StructType\GetAvailableWifiNetworks $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAvailableWifiNetworks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerBestPractices
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Customer Best Practices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerBestPractices $parameters
     * @return \CustomerManagement\StructType\GetCustomerBestPracticesResponse|bool
     */
    public function GetCustomerBestPractices(\CustomerManagement\StructType\GetCustomerBestPractices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerBestPractices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommunicationSetting
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the dual path communication mode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCommunicationSetting $parameters
     * @return \CustomerManagement\StructType\GetCommunicationSettingResponse|bool
     */
    public function GetCommunicationSetting(\CustomerManagement\StructType\GetCommunicationSetting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCommunicationSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDualPathCommunicationStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the dual path communication status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDualPathCommunicationStatus $parameters
     * @return \CustomerManagement\StructType\GetDualPathCommunicationStatusResponse|bool
     */
    public function GetDualPathCommunicationStatus(\CustomerManagement\StructType\GetDualPathCommunicationStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDualPathCommunicationStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventHistory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of recent events. Note that the time frame is limited to 1 day.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEventHistory $parameters
     * @return \CustomerManagement\StructType\GetEventHistoryResponse|bool
     */
    public function GetEventHistory(\CustomerManagement\StructType\GetEventHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEventHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInstantaneousMode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the current setting for Instantaneous mode for sensor activity (beta).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetInstantaneousMode $parameters
     * @return \CustomerManagement\StructType\GetInstantaneousModeResponse|bool
     */
    public function GetInstantaneousMode(\CustomerManagement\StructType\GetInstantaneousMode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInstantaneousMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPendingCommandInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: See if there are any commands waiting to be sent to the system (beta).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetPendingCommandInfo $parameters
     * @return \CustomerManagement\StructType\GetPendingCommandInfoResponse|bool
     */
    public function GetPendingCommandInfo(\CustomerManagement\StructType\GetPendingCommandInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPendingCommandInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLatestCallerVersion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Tells you the latest CallerVersion. CallerVersion is used by a few calls to avoid backwards compatibility problems with enumerations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLatestCallerVersion $parameters
     * @return \CustomerManagement\StructType\GetLatestCallerVersionResponse|bool
     */
    public function GetLatestCallerVersion(\CustomerManagement\StructType\GetLatestCallerVersion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLatestCallerVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllCommitments
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get commitments for a dealer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAllCommitments $parameters
     * @return \CustomerManagement\StructType\GetAllCommitmentsResponse|bool
     */
    public function GetAllCommitments(\CustomerManagement\StructType\GetAllCommitments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllCommitments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetScheduledAppointment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a scheduled service appointment for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetScheduledAppointment $parameters
     * @return \CustomerManagement\StructType\GetScheduledAppointmentResponse|bool
     */
    public function GetScheduledAppointment(\CustomerManagement\StructType\GetScheduledAppointment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetScheduledAppointment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInteractiveLockoutStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Interactive Lockout status of a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetInteractiveLockoutStatus $parameters
     * @return \CustomerManagement\StructType\GetInteractiveLockoutStatusResponse|bool
     */
    public function GetInteractiveLockoutStatus(\CustomerManagement\StructType\GetInteractiveLockoutStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInteractiveLockoutStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnUrl
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get return URL of a page by its name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetReturnUrl $parameters
     * @return \CustomerManagement\StructType\GetReturnUrlResponse|bool
     */
    public function GetReturnUrl(\CustomerManagement\StructType\GetReturnUrl $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReturnUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSolarSystems
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all active solar sites/systems related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSolarSystems $parameters
     * @return \CustomerManagement\StructType\GetSolarSystemsResponse|bool
     */
    public function GetSolarSystems(\CustomerManagement\StructType\GetSolarSystems $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSolarSystems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSolarData
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all active solar sites/systems related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSolarData $parameters
     * @return \CustomerManagement\StructType\GetSolarDataResponse|bool
     */
    public function GetSolarData(\CustomerManagement\StructType\GetSolarData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSolarData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetElectricityProviders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Electricity Providers/Utilities for the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetElectricityProviders $parameters
     * @return \CustomerManagement\StructType\GetElectricityProvidersResponse|bool
     */
    public function GetElectricityProviders(\CustomerManagement\StructType\GetElectricityProviders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetElectricityProviders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetElectricityPlans
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Electricity Plans for the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetElectricityPlans $parameters
     * @return \CustomerManagement\StructType\GetElectricityPlansResponse|bool
     */
    public function GetElectricityPlans(\CustomerManagement\StructType\GetElectricityPlans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetElectricityPlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeviceNotes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all general and equipment device notes related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDeviceNotes $parameters
     * @return \CustomerManagement\StructType\GetDeviceNotesResponse|bool
     */
    public function GetDeviceNotes(\CustomerManagement\StructType\GetDeviceNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeviceNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModemSerialFromIccid
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetModemSerialFromIccid $parameters
     * @return \CustomerManagement\StructType\GetModemSerialFromIccidResponse|bool
     */
    public function GetModemSerialFromIccid(\CustomerManagement\StructType\GetModemSerialFromIccid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetModemSerialFromIccid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSimStatusDuringActivation
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the Carrier Status for a panel during the activation phase.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSimStatusDuringActivation $parameters
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationResponse|bool
     */
    public function GetSimStatusDuringActivation(\CustomerManagement\StructType\GetSimStatusDuringActivation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSimStatusDuringActivation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastMessageDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLastMessageDate $parameters
     * @return \CustomerManagement\StructType\GetLastMessageDateResponse|bool
     */
    public function GetLastMessageDate(\CustomerManagement\StructType\GetLastMessageDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLastMessageDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastCsEventDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLastCsEventDate $parameters
     * @return \CustomerManagement\StructType\GetLastCsEventDateResponse|bool
     */
    public function GetLastCsEventDate(\CustomerManagement\StructType\GetLastCsEventDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLastCsEventDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSignalStrengthSummary
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the Alarm.com Customer Last Signaling Activity/Summary Information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSignalStrengthSummary $parameters
     * @return \CustomerManagement\StructType\GetSignalStrengthSummaryResponse|bool
     */
    public function GetSignalStrengthSummary(\CustomerManagement\StructType\GetSignalStrengthSummary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSignalStrengthSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSignalStrengthHistory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSignalStrengthHistory $parameters
     * @return \CustomerManagement\StructType\GetSignalStrengthHistoryResponse|bool
     */
    public function GetSignalStrengthHistory(\CustomerManagement\StructType\GetSignalStrengthHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSignalStrengthHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeviceList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDeviceList $parameters
     * @return \CustomerManagement\StructType\GetDeviceListResponse|bool
     */
    public function GetDeviceList(\CustomerManagement\StructType\GetDeviceList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeviceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFullEquipmentList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets all equipment from the Alarm.com equipment list, including cameras, zwave devices, fake devices for partitions, ...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetFullEquipmentList $parameters
     * @return \CustomerManagement\StructType\GetFullEquipmentListResponse|bool
     */
    public function GetFullEquipmentList(\CustomerManagement\StructType\GetFullEquipmentList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFullEquipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete. Please call GetCustomerInfo_V2 instead, which improves backwards compatibility by allowing the server to know the API version supported by the client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerInfo $parameters
     * @return \CustomerManagement\StructType\GetCustomerInfoResponse|bool
     */
    public function GetCustomerInfo(\CustomerManagement\StructType\GetCustomerInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerInfo_V2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerInfo_V2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerInfo_V2Response|bool
     */
    public function GetCustomerInfo_V2(\CustomerManagement\StructType\GetCustomerInfo_V2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerInfo_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerPrice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's service plan info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerPrice $parameters
     * @return \CustomerManagement\StructType\GetCustomerPriceResponse|bool
     */
    public function GetCustomerPrice(\CustomerManagement\StructType\GetCustomerPrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerTroubleConditions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete, use GetCustomerTroubleConditions_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerTroubleConditions $parameters
     * @return \CustomerManagement\StructType\GetCustomerTroubleConditionsResponse|bool
     */
    public function GetCustomerTroubleConditions(\CustomerManagement\StructType\GetCustomerTroubleConditions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerTroubleConditions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerTroubleConditions_v2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's trouble conditions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerTroubleConditions_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerTroubleConditions_v2Response|bool
     */
    public function GetCustomerTroubleConditions_v2(\CustomerManagement\StructType\GetCustomerTroubleConditions_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerTroubleConditions_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete, use GetCustomerTroubleConditions_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditions $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsResponse|bool
     */
    public function GetCustomerListWithTroubleConditions(\CustomerManagement\StructType\GetCustomerListWithTroubleConditions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListWithTroubleConditions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditions_v2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of customers matching the trouble condition criteria.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2Response|bool
     */
    public function GetCustomerListWithTroubleConditions_v2(\CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListWithTroubleConditions_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditionsCsv
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete. Use GetCustomerListWithTroubleConditionsCsv_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsvResponse|bool
     */
    public function GetCustomerListWithTroubleConditionsCsv(\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListWithTroubleConditionsCsv($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditionsCsv_v2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of customers matching the trouble condition criteria. Use this method if you have a lot of customers because the performance is much better. Columns: customer_id, device_id, TroubleCondition (TroubleConditionTypeEnum),
     * trouble start date (utc).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2Response|bool
     */
    public function GetCustomerListWithTroubleConditionsCsv_v2(\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListWithTroubleConditionsCsv_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetResolvedTroubleConditionsCsv
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets trouble conditions that have been resolved in the past 60 days. A customer ID can be passed in to restrict the output
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetResolvedTroubleConditionsCsv $parameters
     * @return \CustomerManagement\StructType\GetResolvedTroubleConditionsCsvResponse|bool
     */
    public function GetResolvedTroubleConditionsCsv(\CustomerManagement\StructType\GetResolvedTroubleConditionsCsv $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetResolvedTroubleConditionsCsv($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListFor2G
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: For Alarm.com Internal Use Only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListFor2G $parameters
     * @return \CustomerManagement\StructType\GetCustomerListFor2GResponse|bool
     */
    public function GetCustomerListFor2G(\CustomerManagement\StructType\GetCustomerListFor2G $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListFor2G($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemCheckResults
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the Latest System Check Results for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSystemCheckResults $parameters
     * @return \CustomerManagement\StructType\GetSystemCheckResultsResponse|bool
     */
    public function GetSystemCheckResults(\CustomerManagement\StructType\GetSystemCheckResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSystemCheckResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListWithPanelSetting
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that your login has access to and have a certain value for a panel setting.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithPanelSetting $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithPanelSettingResponse|bool
     */
    public function GetCustomerListWithPanelSetting(\CustomerManagement\StructType\GetCustomerListWithPanelSetting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListWithPanelSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that your login has access to.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerList $parameters
     * @return \CustomerManagement\StructType\GetCustomerListResponse|bool
     */
    public function GetCustomerList(\CustomerManagement\StructType\GetCustomerList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByBranchId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that belong to a branch/sub-dealer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByBranchId $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByBranchIdResponse|bool
     */
    public function GetCustomerListByBranchId(\CustomerManagement\StructType\GetCustomerListByBranchId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListByBranchId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the IDs of customers that use the specified email address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByEmail $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByEmailResponse|bool
     */
    public function GetCustomerListByEmail(\CustomerManagement\StructType\GetCustomerListByEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListByEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByLoginName
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the IDs of customers that have the specified login name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByLoginName $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByLoginNameResponse|bool
     */
    public function GetCustomerListByLoginName(\CustomerManagement\StructType\GetCustomerListByLoginName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerListByLoginName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDownloadableSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the list of downloadable settings with some information about valid options for each.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDownloadableSettings $parameters
     * @return \CustomerManagement\StructType\GetDownloadableSettingsResponse|bool
     */
    public function GetDownloadableSettings(\CustomerManagement\StructType\GetDownloadableSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDownloadableSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUploadedPanelSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns already uploaded settings from the panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetUploadedPanelSettings $parameters
     * @return \CustomerManagement\StructType\GetUploadedPanelSettingsResponse|bool
     */
    public function GetUploadedPanelSettings(\CustomerManagement\StructType\GetUploadedPanelSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUploadedPanelSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retrieves detailed information about an image sensor camera.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorInfoResponse|bool
     */
    public function GetImageSensorInfo(\CustomerManagement\StructType\GetImageSensorInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetImageSensorInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPauseNotificationsForCustomer
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the UTC time that notifications will resume for a customer, as well as if that customer has logged in yet.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetPauseNotificationsForCustomer $parameters
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerResponse|bool
     */
    public function GetPauseNotificationsForCustomer(\CustomerManagement\StructType\GetPauseNotificationsForCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPauseNotificationsForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSecurityQuestions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the list of available security questions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSecurityQuestions $parameters
     * @return \CustomerManagement\StructType\GetSecurityQuestionsResponse|bool
     */
    public function GetSecurityQuestions(\CustomerManagement\StructType\GetSecurityQuestions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSecurityQuestions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllLogins
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all login names for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAllLogins $parameters
     * @return \CustomerManagement\StructType\GetAllLoginsResponse|bool
     */
    public function GetAllLogins(\CustomerManagement\StructType\GetAllLogins $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllLogins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoginInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get login info for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLoginInfo $parameters
     * @return \CustomerManagement\StructType\GetLoginInfoResponse|bool
     */
    public function GetLoginInfo(\CustomerManagement\StructType\GetLoginInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLoginInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\GetAllCommitmentsResponse|\CustomerManagement\StructType\GetAllLoginsResponse|\CustomerManagement\StructType\GetAvailableWifiNetworksResponse|\CustomerManagement\StructType\GetCommunicationSettingResponse|\CustomerManagement\StructType\GetCustomerBestPracticesResponse|\CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityResponse|\CustomerManagement\StructType\GetCustomerInfoResponse|\CustomerManagement\StructType\GetCustomerInfo_V2Response|\CustomerManagement\StructType\GetCustomerListByBranchIdResponse|\CustomerManagement\StructType\GetCustomerListByEmailResponse|\CustomerManagement\StructType\GetCustomerListByLoginNameResponse|\CustomerManagement\StructType\GetCustomerListFor2GResponse|\CustomerManagement\StructType\GetCustomerListResponse|\CustomerManagement\StructType\GetCustomerListWithPanelSettingResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsvResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2Response|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2Response|\CustomerManagement\StructType\GetCustomerPriceResponse|\CustomerManagement\StructType\GetCustomerTroubleConditionsResponse|\CustomerManagement\StructType\GetCustomerTroubleConditions_v2Response|\CustomerManagement\StructType\GetDeviceListResponse|\CustomerManagement\StructType\GetDeviceNotesResponse|\CustomerManagement\StructType\GetDownloadableSettingsResponse|\CustomerManagement\StructType\GetDualPathCommunicationStatusResponse|\CustomerManagement\StructType\GetElectricityPlansResponse|\CustomerManagement\StructType\GetElectricityProvidersResponse|\CustomerManagement\StructType\GetEligibleSensorGroupsResponse|\CustomerManagement\StructType\GetEligibleSensorNamesResponse|\CustomerManagement\StructType\GetEventHistoryResponse|\CustomerManagement\StructType\GetFullEquipmentListResponse|\CustomerManagement\StructType\GetImageSensorInfoResponse|\CustomerManagement\StructType\GetImageSensorLatestCaptureInfoResponse|\CustomerManagement\StructType\GetImageSensorUploadsInfoResponse|\CustomerManagement\StructType\GetInstantaneousModeResponse|\CustomerManagement\StructType\GetInteractiveLockoutStatusResponse|\CustomerManagement\StructType\GetLastCsEventDateResponse|\CustomerManagement\StructType\GetLastMessageDateResponse|\CustomerManagement\StructType\GetLatestCallerVersionResponse|\CustomerManagement\StructType\GetLoginInfoResponse|\CustomerManagement\StructType\GetModemSerialFromIccidResponse|\CustomerManagement\StructType\GetPauseNotificationsForCustomerResponse|\CustomerManagement\StructType\GetPendingCommandInfoResponse|\CustomerManagement\StructType\GetResolvedTroubleConditionsCsvResponse|\CustomerManagement\StructType\GetReturnUrlResponse|\CustomerManagement\StructType\GetScheduledAppointmentResponse|\CustomerManagement\StructType\GetSecurityQuestionsResponse|\CustomerManagement\StructType\GetSignalStrengthHistoryResponse|\CustomerManagement\StructType\GetSignalStrengthSummaryResponse|\CustomerManagement\StructType\GetSimStatusDuringActivationResponse|\CustomerManagement\StructType\GetSolarDataResponse|\CustomerManagement\StructType\GetSolarSystemsResponse|\CustomerManagement\StructType\GetSystemCheckResultsResponse|\CustomerManagement\StructType\GetUploadedPanelSettingsResponse|\CustomerManagement\StructType\GetUserCodesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
