<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemCheckCategoryOutput ArrayType
 * @subpackage Arrays
 */
class ArrayOfSystemCheckCategoryOutput extends AbstractStructArrayBase
{
    /**
     * The SystemCheckCategoryOutput
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\SystemCheckCategoryOutput[]
     */
    public $SystemCheckCategoryOutput;
    /**
     * Constructor method for ArrayOfSystemCheckCategoryOutput
     * @uses ArrayOfSystemCheckCategoryOutput::setSystemCheckCategoryOutput()
     * @param \CustomerManagement\StructType\SystemCheckCategoryOutput[] $systemCheckCategoryOutput
     */
    public function __construct(array $systemCheckCategoryOutput = array())
    {
        $this
            ->setSystemCheckCategoryOutput($systemCheckCategoryOutput);
    }
    /**
     * Get SystemCheckCategoryOutput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput[]|null
     */
    public function getSystemCheckCategoryOutput()
    {
        return isset($this->SystemCheckCategoryOutput) ? $this->SystemCheckCategoryOutput : null;
    }
    /**
     * Set SystemCheckCategoryOutput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SystemCheckCategoryOutput[] $systemCheckCategoryOutput
     * @return \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput
     */
    public function setSystemCheckCategoryOutput(array $systemCheckCategoryOutput = array())
    {
        foreach ($systemCheckCategoryOutput as $arrayOfSystemCheckCategoryOutputSystemCheckCategoryOutputItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemCheckCategoryOutputSystemCheckCategoryOutputItem instanceof \CustomerManagement\StructType\SystemCheckCategoryOutput) {
                throw new \InvalidArgumentException(sprintf('The SystemCheckCategoryOutput property can only contain items of \CustomerManagement\StructType\SystemCheckCategoryOutput, "%s" given', is_object($arrayOfSystemCheckCategoryOutputSystemCheckCategoryOutputItem) ? get_class($arrayOfSystemCheckCategoryOutputSystemCheckCategoryOutputItem) : gettype($arrayOfSystemCheckCategoryOutputSystemCheckCategoryOutputItem)), __LINE__);
            }
        }
        if (is_null($systemCheckCategoryOutput) || (is_array($systemCheckCategoryOutput) && empty($systemCheckCategoryOutput))) {
            unset($this->SystemCheckCategoryOutput);
        } else {
            $this->SystemCheckCategoryOutput = $systemCheckCategoryOutput;
        }
        return $this;
    }
    /**
     * Add item to SystemCheckCategoryOutput value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\SystemCheckCategoryOutput $item
     * @return \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput
     */
    public function addToSystemCheckCategoryOutput(\CustomerManagement\StructType\SystemCheckCategoryOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\SystemCheckCategoryOutput) {
            throw new \InvalidArgumentException(sprintf('The SystemCheckCategoryOutput property can only contain items of \CustomerManagement\StructType\SystemCheckCategoryOutput, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemCheckCategoryOutput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemCheckCategoryOutput
     */
    public function getAttributeName()
    {
        return 'SystemCheckCategoryOutput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
