<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPriceInfo StructType
 * @subpackage Structs
 */
class CustomerPriceInfo extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The BasePackagePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BasePackagePrice;
    /**
     * The BasePackage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BasePackage;
    /**
     * The AddonPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfFeaturePrice
     */
    public $AddonPrices;
    /**
     * Constructor method for CustomerPriceInfo
     * @uses CustomerPriceInfo::setTotalPrice()
     * @uses CustomerPriceInfo::setBasePackagePrice()
     * @uses CustomerPriceInfo::setBasePackage()
     * @uses CustomerPriceInfo::setAddonPrices()
     * @param float $totalPrice
     * @param float $basePackagePrice
     * @param string $basePackage
     * @param \CustomerManagement\ArrayType\ArrayOfFeaturePrice $addonPrices
     */
    public function __construct($totalPrice = null, $basePackagePrice = null, $basePackage = null, \CustomerManagement\ArrayType\ArrayOfFeaturePrice $addonPrices = null)
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setBasePackagePrice($basePackagePrice)
            ->setBasePackage($basePackage)
            ->setAddonPrices($addonPrices);
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \CustomerManagement\StructType\CustomerPriceInfo
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get BasePackagePrice value
     * @return float
     */
    public function getBasePackagePrice()
    {
        return $this->BasePackagePrice;
    }
    /**
     * Set BasePackagePrice value
     * @param float $basePackagePrice
     * @return \CustomerManagement\StructType\CustomerPriceInfo
     */
    public function setBasePackagePrice($basePackagePrice = null)
    {
        $this->BasePackagePrice = $basePackagePrice;
        return $this;
    }
    /**
     * Get BasePackage value
     * @return string|null
     */
    public function getBasePackage()
    {
        return $this->BasePackage;
    }
    /**
     * Set BasePackage value
     * @param string $basePackage
     * @return \CustomerManagement\StructType\CustomerPriceInfo
     */
    public function setBasePackage($basePackage = null)
    {
        // validation for constraint: string
        if (!is_null($basePackage) && !is_string($basePackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basePackage)), __LINE__);
        }
        $this->BasePackage = $basePackage;
        return $this;
    }
    /**
     * Get AddonPrices value
     * @return \CustomerManagement\ArrayType\ArrayOfFeaturePrice|null
     */
    public function getAddonPrices()
    {
        return $this->AddonPrices;
    }
    /**
     * Set AddonPrices value
     * @param \CustomerManagement\ArrayType\ArrayOfFeaturePrice $addonPrices
     * @return \CustomerManagement\StructType\CustomerPriceInfo
     */
    public function setAddonPrices(\CustomerManagement\ArrayType\ArrayOfFeaturePrice $addonPrices = null)
    {
        $this->AddonPrices = $addonPrices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CustomerPriceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
